/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.common.tile.compressor.BaseNeutronCompressorTile;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CompressorScreen
extends BaseContainerScreen<CompressorMenu> {
    private static final ResourceLocation BACKGROUND = Const.rl("textures/gui/compressor.png");

    public CompressorScreen(CompressorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, BACKGROUND);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (pMouseX > x + 63 && pMouseX < x + 79 && pMouseY > y + 35 && pMouseY < y + 51) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(ChatFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                MutableComponent text = Component.literal((String)(CompressorScreen.number(this.getMaterialCount()) + " / " + CompressorScreen.number(this.getMaterialsRequired())));
                tooltip.add(text);
            }
            pGuiGraphics.renderComponentTooltip(this.font, tooltip, pMouseX, pMouseY);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        stack.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        stack.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
    }

    @Override
    protected void renderBgOthers(GuiGraphics pGuiGraphics, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(16);
                pGuiGraphics.blit(BACKGROUND, x + 63, y + 35, 176, 18, i2 + 1, 16);
            }
            if (this.getProgress() > 0 && this.getMaterialCount() >= this.getMaterialsRequired()) {
                i2 = this.getProgressBarScaled(22);
                pGuiGraphics.blit(BACKGROUND, x + 89, y + 35, 176, 0, i2 + 1, 16);
            }
        }
    }

    private Component getMaterialStackDisplayName() {
        CompressorMenu container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity((container = (CompressorMenu)this.getMenu()).getBlockPos())) instanceof BaseNeutronCompressorTile) {
            BaseNeutronCompressorTile compressor = (BaseNeutronCompressorTile)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.getHoverName();
        }
        return Component.literal((String)"");
    }

    private BaseNeutronCompressorTile getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((CompressorMenu)this.getMenu()).getBlockPos())) instanceof BaseNeutronCompressorTile) {
            BaseNeutronCompressorTile compressor = (BaseNeutronCompressorTile)tile;
            return compressor;
        }
        return null;
    }

    public boolean isEjecting() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).isEjecting();
    }

    public boolean hasRecipe() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).hasMaterialStack();
    }

    public int getProgress() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.menu).getProgress();
    }

    public int getMaterialCount() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).getMaterialCount();
    }

    public int getMaterialsRequired() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).getMaterialsRequired();
    }

    public int getTimeRequired() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((BaseNeutronCompressorTile)((Object)((CompressorMenu)this.menu).getTileEntity())).getTimeRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.clamp((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.clamp((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }
}

