/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.extreme;

import com.mojang.serialization.MapCodec;
import committee.nova.mods.avaritia.common.block.ResourceBlock;
import committee.nova.mods.avaritia.init.registry.enums.ModResourceBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlazeCubeBlock
extends ResourceBlock {
    public static final MapCodec<BlazeCubeBlock> CODEC = BlazeCubeBlock.simpleCodec(BlazeCubeBlock::new);
    private static final int BUBBLE_COLUMN_CHECK_DELAY = 20;

    public BlazeCubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlazeCubeBlock(ModResourceBlocks type) {
        super(type);
    }

    public MapCodec<BlazeCubeBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BubbleColumnBlock.updateColumn((LevelAccessor)level, (BlockPos)pos.above(), (BlockState)state);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && facingState.is(Blocks.WATER)) {
            level.scheduleTick(currentPos, (Block)this, 20);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }
}

