/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.container;

import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModCraftContainer
extends TransientCraftingContainer {
    private final AbstractContainerMenu container;
    private final ItemStackWrapper inventory;
    private final boolean autoTable;

    public ModCraftContainer(AbstractContainerMenu menu, ItemStackWrapper inventory, int size) {
        this(menu, inventory, size, false);
    }

    public ModCraftContainer(AbstractContainerMenu menu, ItemStackWrapper inventory, int size, boolean autoTable) {
        super(menu, size, size);
        this.container = menu;
        this.inventory = inventory;
        this.autoTable = autoTable;
    }

    public int getContainerSize() {
        return this.autoTable ? this.inventory.getSlots() - 1 : this.inventory.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.inventory.extractItem(slot, amount, false);
        this.container.slotsChanged((Container)this);
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
        this.container.slotsChanged((Container)this);
    }

    public void setChanged() {
        super.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @NotNull
    public TierInput asCraftInput() {
        int tier = Math.floorDiv(this.getWidth(), 2);
        return TierInput.of(this.getWidth(), this.getHeight(), this.inventory.getStacks(), tier);
    }
}

