/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.container.slot;

import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.common.container.ModCraftContainer;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ModCraftResultSlot
extends Slot {
    private final AbstractContainerMenu container;
    private final ModCraftContainer matrix;
    private final Player player;
    private int removeCount;

    public ModCraftResultSlot(Player pPlayer, AbstractContainerMenu menu, ModCraftContainer matrix, Container container, int index, int xPosition, int yPosition) {
        super(container, index, xPosition, yPosition);
        this.player = pPlayer;
        this.container = menu;
        this.matrix = matrix;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int pAmount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(pAmount, this.getItem().getCount());
        }
        return super.remove(pAmount);
    }

    protected void onQuickCraft(@NotNull ItemStack pStack, int pAmount) {
        this.removeCount += pAmount;
        this.checkTakeAchievements(pStack);
    }

    protected void onSwapCraft(int pNumItemsCrafted) {
        this.removeCount += pNumItemsCrafted;
    }

    public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        Level level = player.level();
        TierInput inventory = this.matrix.asCraftInput();
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remaining = level.getRecipeManager().getRemainingItemsFor((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), (RecipeInput)inventory, level);
        CommonHooks.setCraftingPlayer(null);
        for (int k = 0; k < inventory.height(); ++k) {
            for (int l = 0; l < inventory.width(); ++l) {
                ItemStack remainingStack;
                int index = l + inventory.left() + (k + inventory.top()) * this.matrix.getWidth();
                ItemStack slotStack = this.matrix.getItem(index);
                if (!slotStack.isEmpty()) {
                    this.matrix.removeItem(index, 1);
                    slotStack = this.matrix.getItem(index);
                }
                if ((remainingStack = (ItemStack)remaining.get(l + k * inventory.width())).isEmpty()) continue;
                if (slotStack.isEmpty()) {
                    this.matrix.setItem(index, remainingStack);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remainingStack)) {
                    remainingStack.grow(slotStack.getCount());
                    this.matrix.setItem(index, remainingStack);
                    continue;
                }
                if (player.getInventory().add(remainingStack)) continue;
                player.drop(remainingStack, false);
            }
        }
        this.container.slotsChanged((Container)this.matrix);
    }

    protected void checkTakeAchievements(@NotNull ItemStack pStack) {
        AbstractContainerMenu abstractContainerMenu;
        if (this.removeCount > 0) {
            pStack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)pStack, (Container)this.matrix);
        }
        if ((abstractContainerMenu = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder recipeholder = (RecipeCraftingHolder)abstractContainerMenu;
            recipeholder.awardUsedRecipes(this.player, this.matrix.getItems());
        }
        this.removeCount = 0;
    }
}

