/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CompressorRecipe
implements ICompressorRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int inputCount;
    private final int timeCost;

    public CompressorRecipe(Ingredient input, ItemStack output, int inputCount, int timeCost) {
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{input});
        this.output = output;
        this.inputCount = inputCount;
        this.timeCost = timeCost;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        if (inv.ingredientCount() != 1) {
            return false;
        }
        ItemStack input = inv.getItem(0);
        return Arrays.stream(((Ingredient)this.inputs.getFirst()).getItems()).anyMatch(s -> s.is(input.getItem()));
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider pRegistryAccess) {
        return this.output;
    }

    @NotNull
    public ItemStack getResultItem() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @Override
    public int getTimeCost() {
        return this.timeCost;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.COMPRESSOR_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get();
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorRecipe> {
        public static final MapCodec<CompressorRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> (Ingredient)recipe.inputs.getFirst()), (App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("inputCount", (Object)1000).forGetter(recipe -> recipe.inputCount), (App)Codec.INT.fieldOf("timeCost").forGetter(recipe -> recipe.timeCost)).apply((Applicative)builder, CompressorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompressorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<CompressorRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CompressorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CompressorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int inputCount = buffer.readVarInt();
            int timeCost = buffer.readVarInt();
            return new CompressorRecipe(ingredient, output, inputCount, timeCost);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CompressorRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)recipe.inputs.getFirst()));
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeVarInt(recipe.inputCount);
            buffer.writeVarInt(recipe.timeCost);
        }
    }
}

