/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.api.common.crafting.ShapedRecipePatternCodecs;
import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.api.utils.java.TriFunction;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShapedTableCraftingRecipe
implements ITierCraftingRecipe {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final int tier;
    private TriFunction<Integer, Integer, ItemStack, ItemStack> transformer;

    public ShapedTableCraftingRecipe(ShapedRecipePattern pattern, ItemStack result) {
        this(pattern, result, 0);
    }

    public ShapedTableCraftingRecipe(ShapedRecipePattern pattern, ItemStack result, int tier) {
        this.pattern = pattern;
        this.result = result;
        this.tier = tier;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    public boolean matches(@NotNull TierInput input, @NotNull Level level) {
        if (this.tier != 0 && this.tier != input.tier()) {
            return false;
        }
        return this.pattern.matches((CraftingInput)input);
    }

    @NotNull
    public ItemStack assemble(@NotNull TierInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(TierInput inventory) {
        NonNullList remaining;
        block6: {
            int height;
            int width;
            block7: {
                remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < remaining.size(); ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (!item.hasCraftingRemainingItem()) continue;
                    remaining.set(i, (Object)item.getCraftingRemainingItem());
                }
                if (this.transformer == null) break block6;
                width = this.pattern.width();
                height = this.pattern.height();
                if (inventory.width() != width && inventory.height() != height) {
                    return remaining;
                }
                if (!this.matches(inventory, true)) break block7;
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int index = width - j - 1 + i * width;
                        ItemStack stack = inventory.getItem(j, i);
                        remaining.set(index, (Object)this.transformer.apply(j, i, stack));
                    }
                }
                break block6;
            }
            if (!this.matches(inventory, false)) break block6;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int index = j + i * width;
                    ItemStack stack = inventory.getItem(j, i);
                    remaining.set(index, (Object)this.transformer.apply(j, i, stack));
                }
            }
        }
        return remaining;
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        int width = this.pattern.width();
        int height = this.pattern.height();
        return width < 4 && height < 4 ? 1 : (width < 6 && height < 6 ? 2 : (width < 8 && height < 8 ? 3 : 4));
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    private boolean matches(TierInput inventory, boolean symmetrical) {
        int width = this.pattern.width();
        int height = this.pattern.height();
        NonNullList ingredients = this.pattern.ingredients();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ItemStack stack;
                Ingredient ingredient = symmetrical ? (Ingredient)ingredients.get(width - j - 1 + i * width) : (Ingredient)ingredients.get(j + i * width);
                if (ingredient.test(stack = inventory.getItem(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    public void setTransformer(TriFunction<Integer, Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTableCraftingRecipe> {
        public static final MapCodec<ShapedTableCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ShapedRecipePatternCodecs.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(recipe -> recipe.tier)).apply((Applicative)builder, ShapedTableCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedTableCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ShapedTableCraftingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapedTableCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedTableCraftingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int tier = buffer.readVarInt();
            return new ShapedTableCraftingRecipe(pattern, result, tier);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedTableCraftingRecipe recipe) {
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.tier);
        }
    }
}

