/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EndestPearlEntity
extends ThrowableItemProjectile {
    private LivingEntity shooter;

    public EndestPearlEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public EndestPearlEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.ENDER_PEARL.get()), level);
        this.setPos(x, y, z);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.endest_pearl.get();
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult pos) {
        super.onHitEntity(pos);
        Entity entity = pos.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        if (!this.level().isClientSide) {
            GapingVoidEntity ent = this.shooter != null ? new GapingVoidEntity(this.level(), this.shooter) : new GapingVoidEntity(this.level());
            Direction dir = entity.getDirection();
            Vec3 offset = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ());
            if (this.shooter != null) {
                ent.setUser(this.shooter);
            }
            ent.moveTo(entity.getX() + offset.x * 0.25, entity.getY() + offset.y * 0.25, entity.getZ() + offset.z * 0.25, entity.getYRot(), 0.0f);
            this.level().addFreshEntity((Entity)ent);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        if (!this.level().isClientSide) {
            GapingVoidEntity ent = this.shooter != null ? new GapingVoidEntity(this.level(), this.shooter) : new GapingVoidEntity(this.level());
            Direction dir = result.getDirection();
            Vec3 offset = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ());
            if (this.shooter != null) {
                ent.setUser(this.shooter);
            }
            ent.moveTo((double)pos.getX() + offset.x * 0.25, (double)pos.getY() + offset.y * 0.25, (double)pos.getZ() + offset.z * 0.25, this.getYRot(), 0.0f);
            this.level().addFreshEntity((Entity)ent);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }
}

