/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.arrow;

import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class HeavenArrowEntity
extends Arrow {
    public HeavenArrowEntity(EntityType<? extends Arrow> entityType, Level level) {
        super(entityType, level);
    }

    public HeavenArrowEntity(Level world, Entity pShooter, double xPos, double yPos, double zPos) {
        this((EntityType<? extends Arrow>)((EntityType)ModEntities.HEAVEN_ARROW.get()), world);
        this.setOwner(pShooter);
        this.setPos(xPos, yPos, zPos);
    }

    public HeavenArrowEntity(Level world, Entity pShooter) {
        this(world, pShooter, pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        if (pShooter instanceof Player) {
            this.pickup = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public HeavenArrowEntity(Entity pShooter) {
        this(pShooter.level(), pShooter);
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        RandomSource randy = this.level().random;
        if (this.getOwner() != null) {
            ToolUtils.arrowBarrage(this.getOwner(), this.level(), this.piercedAndKilledEntities, this.pickup, randy, pos);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        float HEAVEN_ARROW_DAMAGE = 500.0f;
        if (this.getOwner() != null) {
            entity.hurt(ModDamageTypes.causeRandomDamage(this.getOwner()), 500.0f);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putDouble("damage", Double.POSITIVE_INFINITY);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBaseDamage(compound.contains("damage") ? compound.getDouble("damage") : Double.POSITIVE_INFINITY);
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

