/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.arrow;

import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class HeavenSubArrowEntity
extends Arrow {
    public HeavenSubArrowEntity(EntityType<? extends Arrow> entityType, Level level) {
        super(entityType, level);
    }

    public HeavenSubArrowEntity(Level world, Entity pShooter, double xPos, double yPos, double zPos) {
        this((EntityType<? extends Arrow>)((EntityType)ModEntities.HEAVEN_SUB_ARROW.get()), world);
        this.setOwner(pShooter);
        this.setPos(xPos, yPos, zPos);
    }

    public HeavenSubArrowEntity(Level world, Entity pShooter) {
        this(world, pShooter, pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        if (pShooter instanceof Player) {
            this.pickup = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public HeavenSubArrowEntity(Entity pShooter) {
        this(pShooter.level(), pShooter);
    }

    public void tick() {
        super.tick();
        if (this.inGround && this.inGroundTime >= 20) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        float HEAVEN_ARROW_DAMAGE = 200.0f;
        if (this.getOwner() != null) {
            if (entity == this.getOwner()) {
                return;
            }
            entity.hurt(ModDamageTypes.causeRandomDamage(this.getOwner()), 200.0f);
        }
        this.discard();
    }
}

