/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class InfinityElytraItem
extends ElytraItem {
    public InfinityElytraItem() {
        super(new Item.Properties().rarity((Rarity)ModRarities.COSMIC.getValue()).fireResistant().stacksTo(1));
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.level().isClientSide && entity.isFallFlying()) {
            double range = 3.0;
            AABB boundingBox = new AABB(entity.getX() - range, entity.getY() - range, entity.getZ() - range, entity.getX() + range, entity.getY() + range, entity.getZ() + range);
            entity.level().getEntitiesOfClass(LivingEntity.class, boundingBox, e -> e != entity && !(e instanceof Player)).forEach(target -> {
                target.hurt(entity.damageSources().flyIntoWall(), ((Double)ModConfig.infinityElytraFlyingRangeDamage.get()).floatValue());
                double dx = target.getX() - entity.getX();
                double dz = target.getZ() - entity.getZ();
                double strength = 1.0;
                target.push(dx * strength, 0.5, dz * strength);
            });
        }
        if (entity.level().isClientSide && entity.isFallFlying()) {
            this.createTrailParticles(entity);
        }
        return true;
    }

    private void createTrailParticles(LivingEntity entity) {
        RandomSource random = entity.level().getRandom();
        for (int i = 0; i < 3; ++i) {
            double offsetX = random.nextGaussian() * 0.1;
            double offsetY = random.nextGaussian() * 0.1;
            double offsetZ = random.nextGaussian() * 0.1;
            double x = entity.getX() - entity.getLookAngle().x * 1.5 + offsetX;
            double y = entity.getY() + (double)(entity.getBbHeight() / 2.0f) + offsetY;
            double z = entity.getZ() - entity.getLookAngle().z * 1.5 + offsetZ;
            entity.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, -entity.getDeltaMovement().x * 0.5 + offsetX * 0.5, -entity.getDeltaMovement().y * 0.5 + offsetY * 0.5, -entity.getDeltaMovement().z * 0.5 + offsetZ * 0.5);
        }
    }

    public boolean canElytraFly(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return true;
    }
}

