/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.common.enchant.InitEnchantment;
import committee.nova.mods.avaritia.api.common.item.iface.IItemEnchant;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModArmorMaterial;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronHorseArmorItem
extends AnimalArmorItem
implements ITooltip,
IItemEnchant {
    private final InitEnchantment FROST_WALKER = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, 10);
    private final InitEnchantment ALL_DAMAGE_PROTECTION = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, 10);
    private final InitEnchantment FALL_PROTECTION = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, 4);

    public NeutronHorseArmorItem() {
        super(ModArmorMaterial.infinite_armor, AnimalArmorItem.BodyType.EQUESTRIAN, false, new Item.Properties().stacksTo(1).rarity(ModRarities.RARE).fireResistant().setNoRepair());
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 10;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.FROST_WALKER)) {
            return 10;
        }
        if (enchantment.is(Enchantments.PROTECTION)) {
            return 10;
        }
        return enchantment.is(Enchantments.FEATHER_FALLING) ? 4 : 0;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.FROST_WALKER.appendHoverText(context, tooltipComponents);
        this.ALL_DAMAGE_PROTECTION.appendHoverText(context, tooltipComponents);
        this.FALL_PROTECTION.appendHoverText(context, tooltipComponents);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, "neutron_horse_armor");
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        if (((ArmorMaterial)ModArmorMaterial.infinite_armor.value()).layers().contains(layer)) {
            return Res.NEUTRON_HORSE_ARMOR;
        }
        return super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }
}

