/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.resources;

import committee.nova.mods.avaritia.api.utils.ContainerUtils;
import committee.nova.mods.avaritia.common.component.InfinityContainerContents;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterClusterItem
extends Item {
    public static final int INV_SIZE = 512;
    public static int CAPACITY = 4096;

    public MatterClusterItem() {
        super(new Item.Properties().rarity(ModRarities.RARE).stacksTo(1));
    }

    public static List<ItemStack> getClusterItems(ItemStack cluster) {
        InfinityContainerContents clusterContainer = (InfinityContainerContents)cluster.getOrDefault((DataComponentType)ModDataComponents.MATTER_CLUSTER.get(), (Object)InfinityContainerContents.EMPTY);
        return clusterContainer.getItems();
    }

    public static int getClusterSize(List<ItemStack> itemStacks) {
        int itemCount = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.isEmpty()) continue;
            itemCount += itemStack.getCount();
        }
        return itemCount;
    }

    public static ItemStack makeClusters(Set<ItemStack> input) {
        SimpleContainer clusterInventory = new SimpleContainer(512);
        int count = 0;
        for (ItemStack itemStack : input) {
            if (count >= CAPACITY || !clusterInventory.canAddItem(itemStack)) continue;
            clusterInventory.addItem(itemStack.copy());
            count += itemStack.getCount();
            itemStack.setCount(0);
        }
        if (count > 0) {
            ItemStack cluster = new ItemStack((ItemLike)ModItems.matter_cluster.get());
            cluster.update((DataComponentType)ModDataComponents.MATTER_CLUSTER.get(), (Object)InfinityContainerContents.EMPTY, clusterContainer -> InfinityContainerContents.fromItems((List<ItemStack>)clusterInventory.getItems()));
            return cluster;
        }
        return ItemStack.EMPTY;
    }

    public static boolean mergeClusters(ItemStack spawnCluster, ItemStack slotCluster) {
        ItemStack stack;
        SimpleContainer slotClusterInv = MatterClusterItem.readClusterInventory(slotCluster);
        ItemStack[] slotClusterItems = (ItemStack[])slotClusterInv.getItems().toArray(ItemStack[]::new);
        SimpleContainer receivingInv = new SimpleContainer((ItemStack[])slotClusterInv.getItems().toArray(ItemStack[]::new));
        int recipientCount = Arrays.stream(slotClusterItems).mapToInt(ItemStack::getCount).sum();
        if (recipientCount >= CAPACITY) {
            return false;
        }
        boolean mergedAny = false;
        SimpleContainer spawnClusterInv = MatterClusterItem.readClusterInventory(spawnCluster);
        ItemStack[] spawnClusterItems = (ItemStack[])spawnClusterInv.getItems().toArray(ItemStack[]::new);
        Iterator iterator = spawnClusterInv.getItems().iterator();
        while (iterator.hasNext() && !(stack = (ItemStack)iterator.next()).isEmpty()) {
            int remainder = ContainerUtils.insertItem((Container)receivingInv, stack, false);
            if (remainder <= stack.getCount()) {
                mergedAny = true;
            }
            stack.setCount(remainder);
            if ((recipientCount += stack.getCount() - remainder) < CAPACITY) continue;
            break;
        }
        MatterClusterItem.writeClusterInventory(slotCluster, receivingInv);
        int spawnClusterRemaining = Arrays.stream(spawnClusterItems).mapToInt(ItemStack::getCount).sum();
        if (spawnClusterRemaining == 0) {
            spawnCluster.setCount(0);
        } else {
            MatterClusterItem.writeClusterInventory(spawnCluster, spawnClusterInv);
        }
        return mergedAny;
    }

    private static void writeClusterInventory(ItemStack cluster, SimpleContainer clusterContents) {
        cluster.update((DataComponentType)ModDataComponents.MATTER_CLUSTER.get(), (Object)InfinityContainerContents.EMPTY, clusterContainer -> InfinityContainerContents.fromItems((List<ItemStack>)clusterContents.getItems()));
    }

    private static SimpleContainer readClusterInventory(ItemStack cluster) {
        InfinityContainerContents slotClusterInv = (InfinityContainerContents)cluster.getOrDefault((DataComponentType)ModDataComponents.MATTER_CLUSTER.get(), (Object)InfinityContainerContents.EMPTY);
        return new SimpleContainer((ItemStack[])slotClusterInv.getItems().toArray(ItemStack[]::new));
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.has((DataComponentType)ModDataComponents.MATTER_CLUSTER.get())) {
            List<ItemStack> itemStacks = MatterClusterItem.getClusterItems(stack);
            int total = MatterClusterItem.getClusterSize(itemStacks);
            if (total > 0) {
                tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.counter", (Object[])new Object[]{total, Math.max(total, CAPACITY)}));
                tooltip.add((Component)Component.literal((String)""));
            }
            if (Screen.hasShiftDown()) {
                ItemStack item;
                Object2IntOpenHashMap itemCounts = new Object2IntOpenHashMap();
                Iterator iterator = MatterClusterItem.readClusterInventory(stack).getItems().iterator();
                while (iterator.hasNext() && !(item = (ItemStack)iterator.next()).isEmpty()) {
                    itemCounts.put((Object)item.getItem(), item.getCount() + itemCounts.getOrDefault((Object)item.getItem(), 0));
                }
                itemCounts.forEach((itemx, count) -> tooltip.add((Component)Component.translatable((String)itemx.getDescriptionId()).append((Component)Component.literal((String)(" x " + count)).withStyle(ChatFormatting.GRAY))));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.desc").withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.desc2").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        List<ItemStack> itemStacks = MatterClusterItem.getClusterItems(stack);
        if (stack.has((DataComponentType)ModDataComponents.MATTER_CLUSTER.get()) && !itemStacks.isEmpty()) {
            if (!level.isClientSide()) {
                for (ItemStack itemStack : itemStacks) {
                    ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), itemStack);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        player.setItemInHand(hand, ItemStack.EMPTY);
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }
}

