/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.singularity;

import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class Singularity {
    public static final StreamCodec<RegistryFriendlyByteBuf, Singularity> STREAM_CODEC = StreamCodec.of(Singularity::encode, Singularity::read);
    private final ResourceLocation id;
    private final String name;
    private final int[] colors;
    private final String tag;
    private final int ingredientCount;
    private final int timeRequired;
    @Nullable
    private Ingredient ingredient;
    private boolean enabled = true;
    private boolean recipeEnabled = true;

    public Singularity(ResourceLocation id, String name, int[] colors, String tag) {
        this(id, name, colors, tag, 1000, 240);
    }

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient) {
        this(id, name, colors, ingredient, 1000, 240);
    }

    public Singularity(ResourceLocation id, String name, int[] colors, @Nullable Ingredient ingredient, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = Arrays.stream(colors).map(c -> FastColor.ARGB32.color((int)255, (int)c)).toArray();
        this.ingredient = ingredient;
        this.tag = null;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = Arrays.stream(colors).map(c -> FastColor.ARGB32.color((int)255, (int)c)).toArray();
        this.ingredient = null;
        this.tag = tag;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public Ingredient getIngredient() {
        if (this.tag != null && this.ingredient == null) {
            TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)this.tag));
            this.ingredient = BuiltInRegistries.ITEM.getTag(tag).isPresent() ? Ingredient.of((TagKey)tag) : Ingredient.EMPTY;
        }
        return this.ingredient != null ? this.ingredient : Ingredient.EMPTY;
    }

    public int getIngredientCount() {
        if (this.ingredientCount == -1) {
            return 1000;
        }
        return this.ingredientCount;
    }

    public Component getDisplayName() {
        return Localizable.of(this.name).build();
    }

    public static Singularity read(RegistryFriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        String name = buffer.readUtf();
        int[] colors = buffer.readVarIntArray();
        boolean isTagIngredient = buffer.readBoolean();
        String tag = null;
        Ingredient ingredient = Ingredient.EMPTY;
        if (isTagIngredient) {
            tag = buffer.readUtf();
        } else {
            ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        }
        int timeRequired = buffer.readVarInt();
        int ingredientCount = buffer.readVarInt();
        Singularity singularity = isTagIngredient ? new Singularity(id, name, colors, tag, ingredientCount, timeRequired) : new Singularity(id, name, colors, ingredient, ingredientCount, timeRequired);
        singularity.enabled = buffer.readBoolean();
        singularity.recipeEnabled = buffer.readBoolean();
        return singularity;
    }

    public static void encode(RegistryFriendlyByteBuf buffer, Singularity singularity) {
        singularity.write(buffer);
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        buffer.writeUtf(this.name);
        buffer.writeVarIntArray(this.colors);
        buffer.writeBoolean(this.tag != null);
        if (this.tag != null) {
            buffer.writeUtf(this.tag);
        } else {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)(this.ingredient != null ? this.ingredient : Ingredient.EMPTY));
        }
        buffer.writeVarInt(this.timeRequired);
        buffer.writeVarInt(this.getIngredientCount());
        buffer.writeBoolean(this.enabled);
        buffer.writeBoolean(this.recipeEnabled);
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public int getTimeRequired() {
        return this.timeRequired;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isRecipeEnabled() {
        return this.recipeEnabled;
    }

    @Generated
    public void setRecipeEnabled(boolean recipeEnabled) {
        this.recipeEnabled = recipeEnabled;
    }
}

