/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalAxeItem
extends AxeItem
implements ITooltip {
    private final String name;

    public CrystalAxeItem(String name) {
        super(ModToolTiers.CRYSTAL, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(CrystalAxeItem.createAttributes((Tier)ModToolTiers.CRYSTAL, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return super.use(world, player, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).level().isClientSide()) {
            serverPlayer.getCooldowns().addCooldown(serverPlayer.getUseItem().getItem(), 1200);
            serverPlayer.stopUsingItem();
            if (serverPlayer.getOffhandItem().getItem() instanceof ShieldItem) {
                serverPlayer.getOffhandItem().setDamageValue(serverPlayer.getOffhandItem().getDamageValue() / 2);
            }
            serverPlayer.level().broadcastEntityEvent((Entity)serverPlayer, (byte)30);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

