/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CrystalPickaxeItem
extends PickaxeItem
implements ITooltip {
    private final String name;

    public CrystalPickaxeItem(String name) {
        super(ModToolTiers.CRYSTAL, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(CrystalPickaxeItem.createAttributes((Tier)ModToolTiers.CRYSTAL, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 0;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return 100.0f;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Holder.Reference SILK_TOUCH = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
        Holder.Reference FORTUNE = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        if (player.isCrouching()) {
            if (EnchantmentHelper.getTagEnchantmentLevel((Holder)SILK_TOUCH, (ItemStack)stack) > 0) {
                ItemUtils.clearEnchants(stack);
                stack.enchant((Holder)FORTUNE, 3);
                if (!world.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"tooltip.crystal_pickaxe.enchant_1"), true);
                }
            } else {
                ItemUtils.clearEnchants(stack);
                stack.enchant((Holder)SILK_TOUCH, 1);
                if (!world.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"tooltip.crystal_pickaxe.enchant_2"), true);
                }
            }
            player.swing(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, player, hand);
    }
}

