/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.common.item.iface.mode.IItemMode;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.init.registry.modes.InfinityMode;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityAxeItem
extends AxeItem
implements IItemMode<InfinityMode> {
    public InfinityAxeItem() {
        super(ModToolTiers.INFINITY, new Item.Properties().component(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT).rarity((Rarity)ModRarities.COSMIC.getValue()).stacksTo(1).fireResistant().attributes(InfinityAxeItem.createAttributes((Tier)ModToolTiers.INFINITY, (float)0.0f, (float)ModToolTiers.INFINITY.getSpeed())));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isCrouching() && !pLevel.isClientSide) {
            this.changeMode(player, itemstack, hand);
            return InteractionResultHolder.success((Object)itemstack);
        }
        return super.use(pLevel, player, hand);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((InfinityMode)this.getMode(stack)).equals(InfinityMode.RANGE) && ToolUtils.canHarvest(pos, level) && miningEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)miningEntity;
                ToolUtils.destroyTree((Player)player, serverLevel, pos, state);
            }
        }
        return false;
    }

    @Override
    public DataComponentType<InfinityMode> getDataComponentType() {
        return (DataComponentType)ModDataComponents.INFINITY_MODE.get();
    }

    @Override
    public InfinityMode getDefaultMode() {
        return InfinityMode.DEFAULT;
    }
}

