/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.common.enchant.InitEnchantment;
import committee.nova.mods.avaritia.api.common.item.iface.IItemEnchant;
import committee.nova.mods.avaritia.api.common.item.iface.mode.IItemMode;
import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenArrowEntity;
import committee.nova.mods.avaritia.common.entity.arrow.TraceArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.modes.InfinityMode;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBowItem
extends BowItem
implements ITooltip,
IItemMode<InfinityMode>,
IItemEnchant,
IBowTransform {
    private final InitEnchantment initEnchantment = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.INFINITY, 10);

    public InfinityBowItem() {
        super(new Item.Properties().component(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT).stacksTo(1).rarity((Rarity)ModRarities.COSMIC.getValue()).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 99;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 1200;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.initEnchantment.getLevel(enchantment);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.initEnchantment.appendHoverText(context, tooltipComponents);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isCrouching() && !pLevel.isClientSide) {
            this.changeMode(player, itemstack, hand);
            return InteractionResultHolder.success((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            int drawTime = this.getUseDuration(stack, (LivingEntity)player) - timeLeft;
            if ((drawTime = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (boolean)true)) < 0) {
                return;
            }
            float VELOCITY_MULTIPLIER = 1.2f;
            float DAMAGE_MULTIPLIER = 5000.0f;
            float draw = InfinityBowItem.getPowerForTime((int)drawTime);
            float powerForTime = draw * VELOCITY_MULTIPLIER;
            boolean isRangeMode = ((InfinityMode)this.getMode(stack)).equals(InfinityMode.RANGE);
            int arrowCount = isRangeMode ? 2 : 1;
            for (int i = 0; i < arrowCount; ++i) {
                Arrow arrowEntity = new HeavenArrowEntity((Entity)player);
                if (isRangeMode && (double)powerForTime >= 0.1) {
                    arrowEntity = new TraceArrowEntity((Entity)player);
                }
                float yawOffset = i == 1 ? 5.0f : 0.0f;
                arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + yawOffset, 0.0f, powerForTime * 3.0f, 0.01f);
                if (draw == 1.0f) {
                    arrowEntity.setCritArrow(true);
                }
                arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() * (double)DAMAGE_MULTIPLIER);
                this.addEnchant(stack, level, (LivingEntity)player, (AbstractArrow)arrowEntity, powerForTime);
                if (i == 0) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
                level.addFreshEntity((Entity)arrowEntity);
            }
        }
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity living, @NotNull ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, living, stack, remainingUseDuration);
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            int elapsed = this.getUseDuration(stack, (LivingEntity)player) - remainingUseDuration;
            double vy = player.getDeltaMovement().y;
            if (elapsed <= 28 && vy > 0.0) {
                player.setDeltaMovement(player.getDeltaMovement().x, vy + 0.07, player.getDeltaMovement().z);
                player.hurtMarked = true;
            }
            if (vy < 0.0) {
                player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 18, 0, false, false, false));
            }
        }
    }

    private void addEnchant(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity player, AbstractArrow arrowEntity, float powerForTime) {
        Holder.Reference POWER = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.POWER);
        Holder.Reference FLAMING = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FLAME);
        int j = EnchantmentHelper.getTagEnchantmentLevel((Holder)POWER, (ItemStack)stack);
        if (j > 0) {
            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + (double)j * 0.5 + 0.5);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Holder)FLAMING, (ItemStack)stack) > 0) {
            arrowEntity.setRemainingFireTicks(100);
        }
        stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        level.addFreshEntity((Entity)arrowEntity);
    }

    @Override
    public DataComponentType<InfinityMode> getDataComponentType() {
        return (DataComponentType)ModDataComponents.INFINITY_MODE.get();
    }

    @Override
    public InfinityMode getDefaultMode() {
        return InfinityMode.DEFAULT;
    }
}

