/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.common.item.iface.mode.IItemMode;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.init.registry.modes.InfinityMode;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityHoeItem
extends HoeItem
implements IItemMode<InfinityMode> {
    public InfinityHoeItem() {
        super(ModToolTiers.INFINITY, new Item.Properties().component(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT).rarity((Rarity)ModRarities.COSMIC.getValue()).stacksTo(1).fireResistant().attributes(InfinityHoeItem.createAttributes((Tier)ModToolTiers.INFINITY, (float)0.0f, (float)ModToolTiers.INFINITY.getSpeed())));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 0;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return Math.max(super.getDestroySpeed(stack, state), 6.0f);
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isCrouching() && !pLevel.isClientSide) {
            this.changeMode(player, itemstack, hand);
            return InteractionResultHolder.success((Object)itemstack);
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (((InfinityMode)this.getMode(itemstack)).equals(InfinityMode.RANGE)) {
                player.swing(hand);
                BlockPos blockPos = player.getOnPos();
                int rang = 7;
                int height = 2;
                ToolUtils.rangeHarvest(serverLevel, player, itemstack, blockPos, rang, height);
                ToolUtils.rangeBonemealable(serverLevel, blockPos, rang, height, 3);
                player.getCooldowns().addCooldown(itemstack.getItem(), 10);
                serverLevel.playSound(player, player.getOnPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 5.0f);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Block targetBlock = world.getBlockState(blockpos).getBlock();
        Player player = context.getPlayer();
        BlockState blockstate = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7));
        int rang = 5;
        BlockPos minPos = blockpos.offset(-rang, 0, -rang);
        BlockPos maxPos = blockpos.offset(rang, 0, rang);
        if (context.getClickedFace() != Direction.DOWN && world.isEmptyBlock(blockpos.above()) && (targetBlock instanceof GrassBlock || targetBlock.equals(Blocks.DIRT) || targetBlock.equals(Blocks.COARSE_DIRT))) {
            if (player != null && !world.isClientSide) {
                if (player.isCrouching() && ((InfinityMode)this.getMode(stack)).equals(InfinityMode.RANGE)) {
                    Iterable boxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
                    for (BlockPos pos : boxMutable) {
                        BlockState state = world.getBlockState(pos);
                        Block block = state.getBlock();
                        if (!world.isEmptyBlock(pos.above())) {
                            for (int i = 1; i <= 3; ++i) {
                                this.harvest(world, pos.above(i));
                            }
                        }
                        if (world.isEmptyBlock(pos.above()) && (block instanceof GrassBlock || block.equals(Blocks.DIRT) || block.equals(Blocks.COARSE_DIRT) || block instanceof FarmBlock)) {
                            world.setBlock(pos, blockstate, 11);
                        }
                        if (world.isEmptyBlock(pos) && !world.isEmptyBlock(pos.below())) {
                            world.setBlock(pos, blockstate, 11);
                        }
                        if (state.getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlock(pos, blockstate, 11);
                    }
                    Iterable inBoxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos.offset(0, 3, 0));
                    Iterable allInBoxMutable = BlockPos.betweenClosed((BlockPos)minPos.offset(-1, 0, -1), (BlockPos)maxPos.offset(1, 4, 1));
                    for (BlockPos pos : allInBoxMutable) {
                        BlockState state;
                        if (this.hasBox(pos, inBoxMutable) || (state = world.getBlockState(pos)).getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlockAndUpdate(pos, Blocks.STONE.defaultBlockState());
                    }
                } else {
                    world.setBlock(blockpos, blockstate, 11);
                }
            }
            world.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private boolean hasBox(BlockPos pos, Iterable<BlockPos> box) {
        for (BlockPos pos1 : box) {
            if (pos1.getX() != pos.getX() || pos1.getY() != pos.getY() || pos1.getZ() != pos.getZ()) continue;
            return true;
        }
        return false;
    }

    private void harvest(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (world.isEmptyBlock(pos) || block instanceof CropBlock || block instanceof StemBlock || block instanceof CocoaBlock || block instanceof SweetBerryBushBlock) {
            return;
        }
        world.destroyBlock(pos, false);
    }

    @Override
    public DataComponentType<InfinityMode> getDataComponentType() {
        return (DataComponentType)ModDataComponents.INFINITY_MODE.get();
    }

    @Override
    public InfinityMode getDefaultMode() {
        return InfinityMode.DEFAULT;
    }
}

