/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.common.enchant.InitEnchantment;
import committee.nova.mods.avaritia.api.common.item.iface.IItemEnchant;
import committee.nova.mods.avaritia.api.iface.IToolTransform;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinitySwordItem
extends SwordItem
implements IItemEnchant,
IToolTransform {
    private final InitEnchantment initEnchantment = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.LOOTING, 10);

    public InfinitySwordItem() {
        super(ModToolTiers.INFINITY, new Item.Properties().rarity((Rarity)ModRarities.COSMIC.getValue()).stacksTo(1).fireResistant().attributes(InfinitySwordItem.createAttributes((Tier)ModToolTiers.INFINITY, (int)0, (float)ModToolTiers.INFINITY.getSpeed())));
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, Player player, @NotNull Entity entity) {
        Level level = player.level();
        Boolean endlessDamage = (Boolean)ModConfig.isSwordAttackEndless.get();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                DamageSource damageSource = player.damageSources().source(ModDamageTypes.INFINITY, (Entity)victim, (Entity)player);
                ToolUtils.sweepAttack((Level)serverLevel, (LivingEntity)player, (Entity)victim);
                if (victim instanceof EnderDragon) {
                    EnderDragon dragon = (EnderDragon)victim;
                    dragon.hurt(dragon.head, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.getTier().getAttackDamageBonus());
                } else if (victim instanceof Player) {
                    Player pvp = (Player)victim;
                    if (ToolUtils.isInfinite((LivingEntity)pvp)) {
                        serverLevel.explode((Entity)player, (double)pvp.getBlockX(), (double)pvp.getBlockY(), (double)pvp.getBlockZ(), 25.0f, Level.ExplosionInteraction.MOB);
                        return true;
                    }
                    this.hurt(victim, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.getTier().getAttackDamageBonus());
                } else {
                    this.hurt(victim, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.getTier().getAttackDamageBonus());
                }
                if (!victim.isDeadOrDying() && endlessDamage.booleanValue()) {
                    victim.setHealth(0.0f);
                    victim.die(damageSource);
                    player.killedEntity(serverLevel, victim);
                }
            }
        }
        return false;
    }

    public boolean hurt(LivingEntity victim, DamageSource pSource, float pAmount) {
        if (victim.level().isClientSide) {
            return false;
        }
        if (victim.isDeadOrDying()) {
            return false;
        }
        if (victim.isSleeping() && !victim.level().isClientSide) {
            victim.stopSleeping();
        }
        boolean flag = false;
        victim.setNoActionTime(0);
        victim.walkAnimation.setSpeed(1.5f);
        victim.lastHurt = pAmount;
        victim.invulnerableTime = 20;
        victim.getCombatTracker().recordDamage(pSource, pAmount);
        victim.setHealth(victim.getHealth() - pAmount);
        victim.gameEvent((Holder)GameEvent.ENTITY_DAMAGE);
        victim.hurtTime = victim.hurtDuration = 10;
        Entity entity1 = pSource.getEntity();
        if (entity1 != null) {
            TamableAnimal tamableEntity;
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity1;
                if (!pSource.is(DamageTypeTags.NO_ANGER)) {
                    victim.setLastHurtByMob(livingentity1);
                }
            }
            if (entity1 instanceof Player) {
                Player player1 = (Player)entity1;
                victim.lastHurtByPlayerTime = 100;
                victim.setLastHurtByPlayer(player1);
            } else if (entity1 instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity1).isTame()) {
                victim.lastHurtByPlayerTime = 100;
                LivingEntity livingentity2 = tamableEntity.getOwner();
                if (livingentity2 instanceof Player) {
                    Player player2 = (Player)livingentity2;
                    victim.setLastHurtByPlayer(player2);
                } else {
                    victim.setLastHurtByPlayer(null);
                }
            }
        }
        victim.level().broadcastDamageEvent((Entity)victim, pSource);
        if (!pSource.is(DamageTypeTags.NO_IMPACT)) {
            victim.hurtMarked = true;
        }
        if (entity1 != null && !pSource.is(DamageTypeTags.IS_EXPLOSION)) {
            double d0 = entity1.getX() - victim.getX();
            double d1 = entity1.getZ() - victim.getZ();
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            victim.knockback((double)0.4f, d0, d1);
            if (!flag) {
                victim.indicateDamage(d0, d1);
            }
        }
        if (victim.isDeadOrDying()) {
            victim.die(pSource);
        } else {
            SoundEvent soundevent = SoundEvents.GENERIC_HURT;
            victim.playSound(soundevent, 2.0f, victim.getVoicePitch());
        }
        boolean flag2 = true;
        victim.lastDamageSource = pSource;
        victim.lastDamageStamp = victim.level().getGameTime();
        if (victim instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)victim, pSource, pAmount, pAmount, flag);
        }
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)entity1, (Entity)victim, pSource, pAmount, pAmount, flag);
        }
        return flag2;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ToolUtils.aoeAttack(player, ((Integer)ModConfig.swordAttackRange.get()).intValue(), ((Integer)ModConfig.swordRangeDamage.get()).intValue(), (Boolean)ModConfig.isSwordAttackAnimal.get(), (Boolean)ModConfig.isSwordAttackLightning.get());
            player.getCooldowns().addCooldown(heldItem.getItem(), 20);
        }
        level.playSound(player, player.getOnPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 5.0f);
        return InteractionResultHolder.success((Object)heldItem);
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 0;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.initEnchantment.getLevel(enchantment);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.initEnchantment.appendHoverText(context, tooltipComponents);
    }
}

