/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.init.registry.ModMenus;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ExtremeAnvilMenu
extends ItemCombinerMenu {
    private String itemName;
    public int repairItemCountCost;

    public ExtremeAnvilMenu(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf buf) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL);
    }

    public ExtremeAnvilMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)ModMenus.extreme_anvil.get(), pContainerId, pPlayerInventory, pAccess);
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, itemStack -> true).withSlot(1, 76, 47, itemStack -> true).withResultSlot(2, 134, 47).build();
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.is(BlockTags.ANVIL);
    }

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return pPlayer.getAbilities().instabuild;
    }

    protected void onTake(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            ItemStack itemstack = this.inputSlots.getItem(1);
            if (!itemstack.isEmpty() && itemstack.getCount() > this.repairItemCountCost) {
                itemstack.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, itemstack);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
    }

    public void createResult() {
        ItemStack itemstack = this.inputSlots.getItem(0);
        int i = 0;
        int k = 0;
        if (!itemstack.isEmpty() && EnchantmentHelper.canStoreEnchantments((ItemStack)itemstack)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemstack1));
            this.repairItemCountCost = 0;
            boolean flag = false;
            if (!itemstack2.isEmpty()) {
                flag = itemstack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemstack1.isDamageableItem() && itemstack1.getItem().isValidRepairItem(itemstack, itemstack2)) {
                    int i3;
                    int l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (l2 <= 0) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        return;
                    }
                    for (i3 = 0; l2 > 0 && i3 < itemstack2.getCount(); ++i3) {
                        int j3 = itemstack1.getDamageValue() - l2;
                        itemstack1.setDamageValue(j3);
                        ++i;
                        l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = i3;
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        return;
                    }
                    if (itemstack1.isDamageableItem() && !flag) {
                        int l = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        int i1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        int j1 = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = itemstack1.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(l1);
                            i += 2;
                        }
                    }
                    ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemstack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
                        int j2;
                        Holder holder = (Holder)entry.getKey();
                        int i2 = itemenchantments$mutable.getLevel(holder);
                        j2 = i2 == (j2 = entry.getIntValue()) ? j2 + 1 : Math.max(j2, i2);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean flag1 = itemstack.supportsEnchantment(holder);
                        if (this.player.getAbilities().instabuild) {
                            flag1 = true;
                        }
                        for (Holder holder1 : itemenchantments$mutable.keySet()) {
                            if (holder1.equals((Object)holder) || Enchantment.areCompatible((Holder)holder, (Holder)holder1)) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                        } else {
                            flag2 = true;
                            itemenchantments$mutable.set(holder, j2);
                        }
                        if (!flag3 || flag2) continue;
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        return;
                    }
                }
            }
            if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
                if (!this.itemName.equals(itemstack.getHoverName().getString())) {
                    k = 1;
                    i += k;
                    itemstack1.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                k = 1;
                i += k;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            if (flag && !itemstack1.isBookEnchantable(itemstack2)) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (i <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                EnchantmentHelper.setEnchantments((ItemStack)itemstack1, (ItemEnchantments)itemenchantments$mutable.toImmutable());
            }
            this.resultSlots.setItem(0, itemstack1);
            this.broadcastChanges();
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public boolean setItemName(String pItemName) {
        String s = ExtremeAnvilMenu.validateName(pItemName);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemstack = this.getSlot(2).getItem();
                if (StringUtil.isBlank((String)s)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)s));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String pItemName) {
        String s = StringUtil.filterText((String)pItemName);
        return s.length() <= 50 ? s : null;
    }
}

