/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.api.common.menu.BaseMenu;
import committee.nova.mods.avaritia.api.common.slot.BlackListSlot;
import committee.nova.mods.avaritia.api.utils.InventoryUtils;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class NeutronRingMenu
extends BaseMenu {
    public ItemStack ring = ItemStack.EMPTY;
    public int slot;

    public NeutronRingMenu(int id, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(id, playerInventory, buf.readInt());
    }

    public NeutronRingMenu(int id, Inventory playerInventory, int slot) {
        super((MenuType)ModMenus.neutron_ring.get(), id, playerInventory);
        int j;
        this.slot = slot;
        if (slot > -1) {
            this.ring = playerInventory.getItem(slot);
        }
        if (this.ring.isEmpty()) {
            this.ring = InventoryUtils.findItemInInv(playerInventory.player, stack -> stack.is((Item)ModItems.neutron_ring.get()), stack -> stack);
        }
        Optional.ofNullable((IItemHandler)this.ring.getCapability(Capabilities.ItemHandler.ITEM)).ifPresent(h -> {
            for (int j = 0; j < h.getSlots(); ++j) {
                int row = j / 9;
                int col = j % 9;
                int xPos = 8 + col * 18;
                int yPos = 18 + row * 18;
                this.addSlot((Slot)new SlotItemHandler(h, j, xPos, yPos));
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new BlackListSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 193 + i * 18, this.ring));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new BlackListSlot((Container)playerInventory, j, 8 + j * 18, 251, this.ring));
        }
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int pIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot1 = (Slot)this.slots.get(pIndex);
        if (slot1.hasItem()) {
            ItemStack slot1Item = slot1.getItem();
            itemStack = slot1Item.copy();
            if (pIndex < 81 ? !this.moveItemStackTo(slot1Item, 81, this.slots.size(), true) : !this.moveItemStackTo(slot1Item, 0, 81, false)) {
                return ItemStack.EMPTY;
            }
            if (slot1Item.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            } else {
                slot1.setChanged();
            }
        }
        return itemStack;
    }
}

