/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class C2SElytraSpeedUpPacket {
    private final boolean customFlying;
    private final boolean boosting;

    public C2SElytraSpeedUpPacket(FriendlyByteBuf buf) {
        this.customFlying = buf.readBoolean();
        this.boosting = buf.readBoolean();
    }

    public C2SElytraSpeedUpPacket(boolean customFlying, boolean boosting) {
        this.customFlying = customFlying;
        this.boosting = boosting;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.customFlying);
        buf.writeBoolean(this.boosting);
    }

    public void run(Supplier<IPayloadContext> ctx) {
        ctx.get().enqueueWork(() -> {
            Player patt0$temp = ((IPayloadContext)ctx.get()).player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (player.getItemBySlot(EquipmentSlot.CHEST).is((Item)ModItems.infinity_elytra.get()) && this.customFlying) {
                if (!player.isFallFlying()) {
                    player.push(0.0, -0.5, 0.0);
                }
                if (this.boosting) {
                    this.applyBoost(player);
                }
            }
        }).exceptionally(e -> {
            ((IPayloadContext)ctx.get()).disconnect((Component)Component.literal((String)("Error processing packet: " + e.getMessage())));
            return null;
        });
    }

    private void applyBoost(ServerPlayer player) {
        Vec3 lookVec = player.getLookAngle();
        double boostStrength = 0.7;
        player.push(lookVec.x * boostStrength, lookVec.y * boostStrength * 0.8, lookVec.z * boostStrength);
        for (int i = 0; i < 15; ++i) {
            player.level().addParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() - lookVec.x * 0.5, player.getY() + (double)(player.getBbHeight() / 2.0f) + (player.level().random.nextDouble() - 0.5) * 0.5, player.getZ() - lookVec.z * 0.5, -lookVec.x * 0.5 + (player.level().random.nextDouble() - 0.5) * 0.2, -0.3 + player.level().random.nextDouble() * 0.3, -lookVec.z * 0.5 + (player.level().random.nextDouble() - 0.5) * 0.2);
        }
    }
}

