/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.container.OffsetContainer;
import committee.nova.mods.avaritia.api.common.wrapper.OffsetItemStackWrapper;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.common.wrappers.StorageItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.util.StorageUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class InfinityChestTile
extends BaseContainerBlockEntity
implements OffsetContainer {
    public Int2ObjectMap<StorageItem> containers = StorageUtils.newContainers();
    private static final Component CONTAINER_NAME = Component.translatable((String)"container.infinity_chest");
    private int page = 0;
    private final ContainerData chestData = new ContainerData(){

        public int get(int index) {
            return index == 0 ? InfinityChestTile.this.page : 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                InfinityChestTile.this.page = value;
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public InfinityChestTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.infinity_chest_tile.get(), pos, state);
    }

    @NotNull
    protected Component getDefaultName() {
        return CONTAINER_NAME;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)this.containers.size(), (Object)ItemStack.EMPTY);
        items.retainAll(this.containers.values().stream().map(StorageItem::getStack).toList());
        return items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        return new InfinityChestMenu(pContainerId, pInventory, this.getBlockPos(), this, this.chestData);
    }

    public void loadFromTag(HolderLookup.Provider lookupProvider, CompoundTag compound) {
        this.containers.clear();
        StorageUtils.loadAllItems(lookupProvider, compound, this.containers);
        this.page = compound.getInt("Page");
    }

    public CompoundTag saveToTag(HolderLookup.Provider lookupProvider, CompoundTag compound) {
        StorageUtils.saveAllItems(lookupProvider, compound, this.containers);
        compound.putInt("Page", this.page);
        return compound;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadFromTag(registries, tag);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveToTag(registries, tag);
    }

    @Override
    public OffsetItemStackWrapper getItemHandler() {
        int slots = (Integer)ModConfig.inventoryRows.get() * 9;
        return OffsetItemStackWrapper.create(this.containers, slots * this.page, slots);
    }
}

