/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile.collector;

import committee.nova.mods.avaritia.api.common.inventory.OnContentsChangedFunction;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.common.tile.collector.CollectorTier;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseNeutronCollectorTile
extends BaseInventoryTileEntity
implements WorldlyContainer {
    public final ItemStackWrapper inventory;
    public SimpleContainerData data = new SimpleContainerData(1);
    private int progress;
    private CollectorTier tier;

    public BaseNeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_collector_tile.get(), pos, state);
        this.inventory = BaseNeutronCollectorTile.createInventoryHandler(slot -> this.setChangedAndDispatch());
        if (state.is((Block)ModBlocks.neutron_collector.get())) {
            this.tier = CollectorTier.DEFAULT;
        } else if (state.is((Block)ModBlocks.dense_neutron_collector.get())) {
            this.tier = CollectorTier.DENSE;
        } else if (state.is((Block)ModBlocks.denser_neutron_collector.get())) {
            this.tier = CollectorTier.DENSER;
        } else if (state.is((Block)ModBlocks.densest_neutron_collector.get())) {
            this.tier = CollectorTier.DENSEST;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BaseNeutronCollectorTile tile) {
        if (tile.canWork()) {
            ItemStack result = tile.inventory.getStackInSlot(0);
            ItemStack stack = tile.tier.production.getItems()[0];
            ++tile.progress;
            tile.data.set(0, tile.progress);
            if (tile.progress >= tile.tier.production_ticks) {
                if (result.isEmpty()) {
                    tile.inventory.setStackInSlot(0, stack.copyWithCount(1));
                } else if (result.is(stack.getItem()) && result.getCount() < 64) {
                    tile.inventory.setStackInSlot(0, ItemUtils.grow(result, 1));
                }
                tile.progress = 0;
                tile.setChangedAndDispatch();
            }
        }
    }

    public static ItemStackWrapper createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return ItemStackWrapper.create(9, onContentsChanged, builder -> {});
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("progress");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("progress", this.progress);
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    protected boolean canWork() {
        return this.inventory.getStackInSlot(0).isEmpty() || this.inventory.getStackInSlot(0).getCount() < 64;
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("container." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCollectorMenu(windowId, playerInventory, this.getBlockPos(), (ContainerData)this.data);
    }

    public CollectorTier getTier() {
        return this.tier;
    }

    public void setTier(CollectorTier tier) {
        this.tier = tier;
    }

    public int getProductionTicks() {
        return this.tier.production_ticks;
    }

    public ItemStack getProduction() {
        return this.tier.production.getItems()[0];
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean canPlaceItemThroughFace(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (index == 0) {
            ItemStack result = this.getInventory().getStackInSlot(0);
            return ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)this.getProduction());
        }
        return false;
    }

    public int getContainerSize() {
        return this.getInventory().getSlots();
    }

    public boolean isEmpty() {
        return this.getInventory().getStacks().isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().getItem(0);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().removeItem(0, amount);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().removeItemNoUpdate(0);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, @NotNull ItemStack itemStack) {
        if (slot == 0) {
            this.getInventory().toRecipeInventory().setItem(0, itemStack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        BlockPos blockPos = this.getBlockPos();
        return player.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
    }
}

