/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile.compressor;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.inventory.CachedRecipe;
import committee.nova.mods.avaritia.api.common.inventory.OnContentsChangedFunction;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.common.tile.compressor.CompressorTier;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseNeutronCompressorTile
extends BaseInventoryTileEntity
implements WorldlyContainer {
    private final ItemStackWrapper inventory;
    private final ItemStackWrapper recipeInventory;
    private final SimpleContainerData data = new SimpleContainerData(1);
    private final CachedRecipe<CraftingInput, ICompressorRecipe> recipe;
    private ItemStack materialStack = ItemStack.EMPTY;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private CompressorTier tier;

    public BaseNeutronCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_compressor_tile.get(), pos, state);
        this.inventory = BaseNeutronCompressorTile.createInventoryHandler(slot -> this.setChanged());
        this.recipeInventory = ItemStackWrapper.create(1);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get());
        if (state.is((Block)ModBlocks.neutron_compressor.get())) {
            this.tier = CompressorTier.DEFAULT;
        } else if (state.is((Block)ModBlocks.dense_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSE;
        } else if (state.is((Block)ModBlocks.denser_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSER;
        } else if (state.is((Block)ModBlocks.densest_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSEST;
        }
    }

    public static ItemStackWrapper createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return ItemStackWrapper.create(2, onContentsChanged, builder -> {
            builder.setOutputSlots(0);
            builder.setCanInsert((slot, stack) -> slot == 1);
        });
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BaseNeutronCompressorTile tile) {
        if (level == null || tile == null) {
            return;
        }
        ICompressorRecipe recipe = tile.getActiveRecipe();
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        if (!level.isClientSide()) {
            int addCount;
            if (!input.isEmpty()) {
                if (tile.materialStack.isEmpty() || tile.materialCount <= 0) {
                    tile.materialStack = input.copy();
                    tile.setChangedFast();
                }
                if (recipe != null && (float)tile.materialCount < (float)recipe.getInputCount() * tile.tier.inputAmplifier && ItemUtils.areStacksSameType(input, tile.materialStack)) {
                    int consumeAmount = input.getCount();
                    consumeAmount = Math.min(consumeAmount, Mth.ceil((float)((float)recipe.getInputCount() * tile.tier.inputAmplifier)) - tile.materialCount);
                    input.shrink(consumeAmount);
                    tile.materialCount += consumeAmount;
                    tile.setChangedFast();
                }
            }
            if (recipe != null && (float)tile.materialCount >= (float)recipe.getInputCount() * tile.tier.inputAmplifier) {
                CraftingInput craftingInput;
                ItemStack baseResult;
                ItemStack result;
                ++tile.progress;
                tile.data.set(0, tile.progress);
                if ((float)tile.progress >= (float)recipe.getTimeCost() * tile.tier.timeAmplifier && ItemUtils.canCombineStacks(result = (baseResult = recipe.assemble((RecipeInput)(craftingInput = tile.recipeInventory.toShapelessCraftingInput()), (HolderLookup.Provider)level.registryAccess())).copyWithCount(baseResult.getCount() * tile.tier.outputAmplifier), output)) {
                    tile.updateResult(result);
                    tile.progress = 0;
                    tile.materialCount -= Mth.ceil((float)((float)recipe.getInputCount() * tile.tier.inputAmplifier));
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.EMPTY;
                    }
                    tile.setChangedFast();
                }
            }
            if (tile.ejecting && tile.materialCount > 0 && !tile.materialStack.isEmpty() && (output.isEmpty() || ItemUtils.areStacksSameType(tile.materialStack, output)) && (addCount = Math.min(tile.materialCount, tile.materialStack.getMaxStackSize() - output.getCount())) > 0) {
                ItemStack toAdd = ItemUtils.withSize(tile.materialStack, addCount, false);
                tile.updateResult(toAdd);
                tile.materialCount -= addCount;
                if (tile.materialCount < 1) {
                    tile.materialStack = ItemStack.EMPTY;
                    tile.ejecting = false;
                }
                if (tile.progress > 0) {
                    tile.progress = 0;
                }
                tile.setChangedFast();
            }
        }
        tile.dispatchIfChanged();
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.materialCount = tag.getInt("MaterialCount");
        this.materialStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("MaterialStack"));
        this.progress = tag.getInt("Progress");
        this.ejecting = tag.getBoolean("Ejecting");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("MaterialCount", this.materialCount);
        tag.put("MaterialStack", this.materialStack.saveOptional(registries));
        tag.putInt("Progress", this.progress);
        tag.putBoolean("Ejecting", this.ejecting);
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new CompressorMenu(windowId, playerInventory, this.inventory, this.getBlockPos(), (ContainerData)this.data);
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.isEmpty();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.setChangedAndDispatch();
        }
    }

    public boolean hasRecipe() {
        return this.recipe.exists();
    }

    public ICompressorRecipe getActiveRecipe() {
        if (this.level == null || this.materialStack.isEmpty()) {
            return null;
        }
        this.recipeInventory.setStackInSlot(0, this.materialStack);
        return this.recipe.checkAndGet(this.toCraftingInput(), this.level);
    }

    private CraftingInput toCraftingInput() {
        return this.recipeInventory.toShapelessCraftingInput();
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return Mth.ceil((float)((float)this.getActiveRecipe().getInputCount() * this.tier.inputAmplifier));
        }
        return 0;
    }

    public int getTimeRequired() {
        if (this.hasRecipe()) {
            return Mth.ceil((float)((float)this.getActiveRecipe().getTimeCost() * this.tier.timeAmplifier));
        }
        return 0;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.isEmpty()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, ItemUtils.grow(result, stack.getCount()));
        }
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (stack.isEmpty()) {
            return false;
        }
        if (index == 1) {
            if (this.getInventory().getStackInSlot(1).isEmpty()) {
                return true;
            }
            if (!this.hasRecipe()) {
                return false;
            }
            if (!this.materialStack.isEmpty()) {
                return ItemStack.isSameItemSameComponents((ItemStack)this.getInventory().getStackInSlot(1), (ItemStack)this.materialStack);
            }
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return index == 0 && direction != Direction.UP;
    }

    public int getContainerSize() {
        return this.getInventory().getSlots();
    }

    public boolean isEmpty() {
        return this.getInventory().getStacks().isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().getItem(0);
        }
        return this.getInventory().toRecipeInventory().getItem(1);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().removeItem(0, amount);
        }
        if (slot == 1) {
            return this.getInventory().toRecipeInventory().removeItem(1, amount);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot == 0) {
            return this.getInventory().toRecipeInventory().removeItemNoUpdate(0);
        }
        if (slot == 1) {
            return this.getInventory().toRecipeInventory().removeItemNoUpdate(1);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            this.getInventory().toRecipeInventory().setItem(0, stack);
        } else if (slot == 1) {
            this.getInventory().toRecipeInventory().setItem(1, stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        BlockPos blockPos = this.getBlockPos();
        return player.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5) <= 64.0;
    }

    public CompressorTier getTier() {
        return this.tier;
    }

    public void setTier(CompressorTier tier) {
        this.tier = tier;
    }

    public void clearContent() {
    }
}

