/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.avaritia.CraftingTable")
@ZenRegister
public class CraftingTable
implements IRecipeManager<ITierCraftingRecipe> {
    @ZenCodeType.Method
    public void addShaped(String name, int tier, IItemStack output, IIngredient[][] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"avaritia").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.withSize((int)(height * width), (Object)Ingredient.EMPTY);
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                IIngredient iing = inputs[a][b];
                Ingredient ing = iing.asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
            }
        }
        ShapedRecipePattern pattern = new ShapedRecipePattern(width, height, ingredients, Optional.empty());
        ShapedTableCraftingRecipe recipe = new ShapedTableCraftingRecipe(pattern, output.getInternal(), tier);
        recipe.setTransformer((x, y, stack) -> inputs[y][x].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void addShapeless(String name, IItemStack output, IIngredient[] inputs) {
        this.addShapeless(name, 0, output, inputs);
    }

    @ZenCodeType.Method
    public void addShapeless(String name, int tier, IItemStack output, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"avaritia").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        ShapelessTableCraftingRecipe recipe = new ShapelessTableCraftingRecipe(CraftingTable.toIngredientsList(inputs), output.getInternal(), tier);
        recipe.setTransformers((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void addCatalyst(String name, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        InfinityCatalystCraftRecipe recipe = new InfinityCatalystCraftRecipe("default", CraftingTable.toIngredientsList(inputs), 1);
        recipe.setTransformers((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> ((ITierCraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).is(stack.getInternal().getItem())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::create));
    }

    public RecipeType<ITierCraftingRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get();
    }
}

