/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.emi.category.tables;

import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record EndCraftingTableCategory(RecipeHolder<ITierCraftingRecipe> recipe) implements EmiRecipe
{
    private static final EmiTexture TEXTURE = new EmiTexture(ResourceLocation.tryBuild((String)"avaritia", (String)"textures/gui/jei/tables/end_jei.png"), 0, 0, 193, 133);
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)ModBlocks.end_crafting_table.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(ResourceLocation.tryBuild((String)"avaritia", (String)"end_crafting_table"), (EmiRenderable)WORKSTATION);

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return ((ITierCraftingRecipe)this.recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
    }

    public List<EmiStack> getOutputs() {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        return List.of(EmiStack.of((ItemStack)((ITierCraftingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())));
    }

    public int getDisplayWidth() {
        return 195;
    }

    public int getDisplayHeight() {
        return 135;
    }

    public void addWidgets(WidgetHolder widgets) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = ((ITierCraftingRecipe)this.recipe.value()).getIngredients();
        ItemStack output = ((ITierCraftingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
        widgets.addTexture(TEXTURE, 1, 1);
        Recipe recipe = this.recipe.value();
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(7 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(7 - shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    widgets.addSlot(EmiIngredient.of((Ingredient)((Ingredient)inputs.get(stackIndex))), j * 18 + 5, i * 18 + 5).drawBack(false);
                    ++stackIndex;
                }
            }
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output), 169, 58).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe.value() instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output), 169, 58).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe.value() instanceof InfinityCatalystCraftRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.infinity_catalyst.get())), 169, 58).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe.value() instanceof EternalSingularityCraftRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.eternal_singularity.get())), 169, 58).recipeContext((EmiRecipe)this).drawBack(false);
        }
    }

    private void shapelessRecipe(@NotNull WidgetHolder widgetHolder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int index = j + i * 7;
                if (index >= inputs.size()) continue;
                widgetHolder.addSlot(EmiIngredient.of((Ingredient)((Ingredient)inputs.get(index))), j * 18 + 2, i * 18 + 2).drawBack(false);
            }
        }
        widgetHolder.addTexture(EmiTexture.SHAPELESS, 173, 140);
    }
}

