/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei.category.tables;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ExtremeCraftingTableCategory
implements IRecipeCategory<RecipeHolder<ITierCraftingRecipe>> {
    public static final RecipeType<RecipeHolder<ITierCraftingRecipe>> RECIPE_TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Const.rl("extreme_craft"));
    private static final ResourceLocation TEXTURE = Const.rl("textures/gui/jei/tables/extreme_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public ExtremeCraftingTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 190, 163);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.extreme_crafting_table.get()));
    }

    @NotNull
    public RecipeType<RecipeHolder<ITierCraftingRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Localizable.of("jei.category.avaritia.extreme_crafting_table").build();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ITierCraftingRecipe> recipeHolder, @NotNull IFocusGroup focuses) {
        ITierCraftingRecipe recipe = (ITierCraftingRecipe)recipeHolder.value();
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(9 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(9 - shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(output);
        } else if (recipe instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(output);
        } else if (recipe instanceof InfinityCatalystCraftRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(new ItemStack((ItemLike)ModItems.infinity_catalyst.get()));
        } else if (recipe instanceof EternalSingularityCraftRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(new ItemStack((ItemLike)ModItems.eternal_singularity.get()));
        }
        builder.moveRecipeTransferButton(170, 120);
    }

    private void shapelessRecipe(@NotNull IRecipeLayoutBuilder builder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = j + i * 9;
                if (index >= inputs.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(index));
            }
        }
        builder.setShapeless(163, 150);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull RecipeHolder<ITierCraftingRecipe> recipeHolder, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ITierCraftingRecipe recipe = (ITierCraftingRecipe)recipeHolder.value();
        boolean shapeless = recipe instanceof ShapelessTableCraftingRecipe;
        int sX = (shapeless ? 340 : 306) / 2;
        int sY = 100;
        if (shapeless && mouseX > (double)(sX + 10) && mouseX < (double)(sX + 20) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            tooltip.add((FormattedText)Localizable.of("jei.tooltip.shapeless.recipe").build());
        }
    }
}

