/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.recipe;

import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ModExtremeSmithingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient additions;
    private final Item result;
    private final int count;
    private final ItemStack resultStack;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private ICondition[] conditions;

    public ModExtremeSmithingRecipeBuilder(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, ItemStack pResult) {
        this.category = pCategory;
        this.template = pTemplate;
        this.base = pBase;
        this.additions = pAddition;
        this.count = pResult.getCount();
        this.result = pResult.getItem();
        this.resultStack = pResult;
    }

    public static ModExtremeSmithingRecipeBuilder smithing(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, ItemStack pResult) {
        return new ModExtremeSmithingRecipeBuilder(pTemplate, pBase, pAddition, pCategory, pResult);
    }

    @NotNull
    public ModExtremeSmithingRecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public ModExtremeSmithingRecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result;
    }

    @NotNull
    public ModExtremeSmithingRecipeBuilder conditions(ICondition ... conditions) {
        this.conditions = conditions;
        return this;
    }

    public void save(RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ExtremeSmithingRecipe shapelessrecipe = new ExtremeSmithingRecipe(this.template, this.base, this.additions, this.resultStack);
        if (this.conditions != null) {
            recipeOutput.accept(id, (Recipe)shapelessrecipe, advancement$builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")), this.conditions);
        } else {
            recipeOutput.accept(id, (Recipe)shapelessrecipe, advancement$builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
        }
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

