/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.init.event.RegisterRecipesEvent;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class InternalRecipeHandler {
    @SubscribeEvent
    public static void onRegisterRecipes(RegisterRecipesEvent event) {
        SingularityRegistryHandler.getInstance().loadSingularities();
        List<Singularity> allSingularities = SingularityRegistryHandler.getInstance().getSingularities();
        for (Singularity singularity : allSingularities) {
            RecipeHolder<CompressorRecipe> compressorRecipe;
            if (!singularity.isEnabled() || !singularity.isRecipeEnabled() || (compressorRecipe = InternalRecipeHandler.makeSingularityRecipe(singularity)) == null) continue;
            event.addRecipe(compressorRecipe);
        }
    }

    private static RecipeHolder<CompressorRecipe> makeSingularityRecipe(Singularity singularity) {
        Ingredient ingredient = singularity.getIngredient();
        if (ingredient == Ingredient.EMPTY) {
            return null;
        }
        ResourceLocation recipeId = Const.rl(singularity.getId().getPath() + "_singularity");
        ItemStack output = SingularityUtils.getItemForSingularity(singularity);
        int ingredientCount = singularity.getIngredientCount();
        int timeRequired = singularity.getTimeRequired();
        return new RecipeHolder(recipeId, (Recipe)new CompressorRecipe(ingredient, output, ingredientCount, timeRequired));
    }
}

