/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.common.item.misc.InfinityUmbrellaItem;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityCrossBowItem;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.modes.InfinityMode;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

@EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ItemOverrideHandler {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_pickaxe.get(), Const.rl("hammer"), (itemStack, world, livingEntity, d) -> ((InfinityMode)itemStack.getOrDefault(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT)).equals(InfinityMode.RANGE) ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_shovel.get(), Const.rl("destroyer"), (itemStack, world, livingEntity, d) -> ((InfinityMode)itemStack.getOrDefault(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT)).equals(InfinityMode.RANGE) ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.matter_cluster.get(), Const.rl("cap"), (itemStack, world, livingEntity, d) -> MatterClusterItem.getClusterSize(MatterClusterItem.getClusterItems(itemStack)) == MatterClusterItem.CAPACITY ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_bow.get(), Const.rl("pull"), (itemStack, world, livingEntity, d) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return CrossbowItem.isCharged((ItemStack)itemStack) ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)itemStack, (LivingEntity)livingEntity);
            });
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_bow.get(), Const.rl("pulling"), (itemStack, world, livingEntity, d) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack && !CrossbowItem.isCharged((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_bow.get(), Const.rl("tracer"), (itemStack, world, livingEntity, d) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return CrossbowItem.isCharged((ItemStack)itemStack) && ((InfinityMode)itemStack.getOrDefault(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT)).equals(InfinityMode.RANGE) ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)itemStack, (LivingEntity)livingEntity);
            });
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_bow.get(), Const.rl("tracing"), (itemStack, world, livingEntity, d) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack && !CrossbowItem.isCharged((ItemStack)itemStack) && ((InfinityMode)itemStack.getOrDefault(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT)).equals(InfinityMode.RANGE) ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_crossbow.get(), Const.rl("pull"), (itemStack, world, livingEntity, d) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return InfinityCrossBowItem.isCharged((ItemStack)itemStack) ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / (float)InfinityCrossBowItem.getChargeDuration((ItemStack)itemStack, (LivingEntity)livingEntity);
            });
            ItemOverrideHandler.setPropertyOverride(Items.CROSSBOW, Const.rl("pulling"), (itemStack, level, livingEntity, i) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack && !InfinityCrossBowItem.isCharged((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemOverrideHandler.setPropertyOverride((Item)ModItems.infinity_crossbow.get(), Const.rl("charged"), (itemStack, world, livingEntity, d) -> InfinityCrossBowItem.isCharged((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.infinity_umbrella.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"avaritia", (String)"mode"), (stack, world, entity, seed) -> ISwitchable.getCurrentMode(stack, InfinityUmbrellaItem.MODES));
        });
    }

    public static void setPropertyOverride(Item itemProvider, ResourceLocation override, ItemPropertyFunction propertyGetter) {
        ItemProperties.register((Item)itemProvider.asItem(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
    }
}

