/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.common.net.S2CSingularitiesPack;
import committee.nova.mods.avaritia.init.registry.ModSingularities;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

@EventBusSubscriber
public class SingularityRegistryHandler {
    private static final SingularityRegistryHandler INSTANCE = new SingularityRegistryHandler();
    private final Map<ResourceLocation, Singularity> singularities = new LinkedHashMap<ResourceLocation, Singularity>();

    public static SingularityRegistryHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        S2CSingularitiesPack message = new S2CSingularitiesPack(SingularityRegistryHandler.getInstance().getSingularities());
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void loadSingularities() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = FMLPaths.CONFIGDIR.get().resolve("avaritia/singularities/").toFile();
        this.writeDefaultSingularityFiles();
        this.singularities.clear();
        if (!dir.mkdirs() && dir.isDirectory()) {
            this.loadFiles(dir);
        }
        EternalSingularityCraftRecipe.invalidate();
        stopwatch.stop();
        Const.LOGGER.info("Loaded {} singularity type(s) in {} ms", (Object)this.singularities.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDefaultSingularityFiles() {
        File dir = FMLPaths.CONFIGDIR.get().resolve("avaritia" + File.separator + "singularities").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            Const.LOGGER.warn("Could not find default singularities,try to generate!");
            for (Singularity singularity : ModSingularities.getDefaults()) {
                JsonObject json = SingularityUtils.writeToJson(singularity);
                FileWriter writer = null;
                try {
                    File file = new File(dir, singularity.getId().getPath() + ".json");
                    writer = new FileWriter(file);
                    Const.GSON.toJson((JsonElement)json, (Appendable)writer);
                    writer.close();
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (Exception e) {
                    Const.LOGGER.error("An error occurred while generating default singularities", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }
    }

    public List<Singularity> getSingularities() {
        return Lists.newArrayList(this.singularities.values());
    }

    public Singularity getSingularityById(ResourceLocation id) {
        return this.singularities.get(id);
    }

    public void loadSingularities(S2CSingularitiesPack message) {
        Map<ResourceLocation, Singularity> singularities = message.singularities().stream().collect(Collectors.toMap(Singularity::getId, s -> s));
        this.singularities.clear();
        this.singularities.putAll(singularities);
        EternalSingularityCraftRecipe.invalidate();
        Const.LOGGER.info("Loaded {} singularities from the server", (Object)singularities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(File dir) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            Singularity singularity = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                String name = file.getName().replace(".json", "");
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                singularity = SingularityUtils.loadFromJson(Const.rl(name), json);
                reader.close();
            }
            catch (Exception e) {
                try {
                    Const.LOGGER.error("An error occurred while loading singularities", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (singularity == null || !singularity.isEnabled()) continue;
            ResourceLocation id = singularity.getId();
            this.singularities.put(id, singularity);
        }
    }
}

