/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry;

import committee.nova.mods.avaritia.api.common.block.BaseBlock;
import committee.nova.mods.avaritia.api.common.item.BaseBlockItem;
import committee.nova.mods.avaritia.common.block.ResourceBlock;
import committee.nova.mods.avaritia.common.block.cake.EndlessCakeBlock;
import committee.nova.mods.avaritia.common.block.chest.CompressedChestBlock;
import committee.nova.mods.avaritia.common.block.chest.InfinityChestBlock;
import committee.nova.mods.avaritia.common.block.collector.BaseNeutronCollectorBlock;
import committee.nova.mods.avaritia.common.block.compressor.BaseNeutronCompressorBlock;
import committee.nova.mods.avaritia.common.block.craft.CompressedCraftTableBlock;
import committee.nova.mods.avaritia.common.block.craft.DoubleCompressedCraftTableBlock;
import committee.nova.mods.avaritia.common.block.craft.TierCraftTableBlock;
import committee.nova.mods.avaritia.common.block.extreme.BlazeCubeBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeAnvilBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeSmithingTableBlock;
import committee.nova.mods.avaritia.common.block.misc.SoulFarmLandBlock;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.enums.ModCraftTier;
import committee.nova.mods.avaritia.init.registry.enums.ModResourceBlocks;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"avaritia");
    public static final Map<String, Supplier<BlockItem>> BLOCK_ITEMS = new LinkedHashMap<String, Supplier<BlockItem>>();
    public static DeferredBlock<Block> compressed_crafting_table = ModBlocks.itemBlock("compressed_crafting_table", CompressedCraftTableBlock::new, ModRarities.UNCOMMON);
    public static DeferredBlock<Block> double_compressed_crafting_table = ModBlocks.itemBlock("double_compressed_crafting_table", DoubleCompressedCraftTableBlock::new, ModRarities.UNCOMMON);
    public static DeferredBlock<Block> neutron = ModBlocks.itemBlock("neutron", () -> new ResourceBlock(ModResourceBlocks.NEUTRON), ModRarities.EPIC);
    public static DeferredBlock<Block> infinity = ModBlocks.itemBlock("infinity", () -> new ResourceBlock(ModResourceBlocks.INFINITY), (Rarity)ModRarities.COSMIC.getValue());
    public static DeferredBlock<Block> crystal_matrix = ModBlocks.itemBlock("crystal_matrix", () -> new ResourceBlock(ModResourceBlocks.CRYSTAL), ModRarities.RARE);
    public static DeferredBlock<Block> blaze_cube_block = ModBlocks.itemBlock("blaze_cube_block", () -> new BlazeCubeBlock(ModResourceBlocks.BLAZE), ModRarities.RARE);
    public static DeferredBlock<Block> compressed_chest = ModBlocks.itemBlock("compressed_chest", CompressedChestBlock::new, ModRarities.RARE);
    public static DeferredBlock<Block> infinity_chest = ModBlocks.itemBlock("infinity_chest", InfinityChestBlock::new, (Rarity)ModRarities.LEGEND.getValue());
    public static DeferredBlock<Block> soul_farmland = ModBlocks.itemBlock("soul_farmland", SoulFarmLandBlock::new, ModRarities.RARE);
    public static DeferredBlock<Block> diamond_lattice_block = ModBlocks.itemBlock("diamond_lattice_block", () -> new BaseBlock(BlockBehaviour.Properties.of().strength(100.0f, 100.0f).sound(SoundType.GLASS)), true, new Item.Properties().rarity(ModRarities.UNCOMMON));
    public static DeferredBlock<Block> star_fuel_block = ModBlocks.itemBurnBlock("star_fuel_block", () -> new BaseBlock(BlockBehaviour.Properties.of().strength(100.0f, 200.0f).sound(SoundType.STONE)), true, new Item.Properties().rarity(ModRarities.RARE), Integer.MAX_VALUE);
    public static DeferredBlock<Block> refined_coal_block = ModBlocks.itemBurnBlock("refined_coal_block", () -> new BaseBlock(BlockBehaviour.Properties.of().strength(50.0f, 50.0f).sound(SoundType.STONE)), true, new Item.Properties().rarity(ModRarities.UNCOMMON), 1440000);
    public static DeferredBlock<Block> sculk_crafting_table = ModBlocks.itemBlock("sculk_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.SCULK), ModRarities.COMMON);
    public static DeferredBlock<Block> nether_crafting_table = ModBlocks.itemBlock("nether_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.NETHER), ModRarities.UNCOMMON);
    public static DeferredBlock<Block> end_crafting_table = ModBlocks.itemBlock("end_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.END), ModRarities.RARE);
    public static DeferredBlock<Block> extreme_crafting_table = ModBlocks.itemBlock("extreme_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.EXTREME), ModRarities.EPIC);
    public static DeferredBlock<Block> neutron_collector = ModBlocks.itemBlock("neutron_collector", BaseNeutronCollectorBlock::new, ModRarities.RARE);
    public static DeferredBlock<Block> dense_neutron_collector = ModBlocks.itemBlock("dense_neutron_collector", BaseNeutronCollectorBlock::new, ModRarities.EPIC);
    public static DeferredBlock<Block> denser_neutron_collector = ModBlocks.itemBlock("denser_neutron_collector", BaseNeutronCollectorBlock::new, (Rarity)ModRarities.LEGEND.getValue());
    public static DeferredBlock<Block> densest_neutron_collector = ModBlocks.itemBlock("densest_neutron_collector", BaseNeutronCollectorBlock::new, (Rarity)ModRarities.COSMIC.getValue());
    public static DeferredBlock<Block> neutron_compressor = ModBlocks.itemBlock("neutron_compressor", BaseNeutronCompressorBlock::new, ModRarities.RARE);
    public static DeferredBlock<Block> dense_neutron_compressor = ModBlocks.itemBlock("dense_neutron_compressor", BaseNeutronCompressorBlock::new, ModRarities.EPIC);
    public static DeferredBlock<Block> denser_neutron_compressor = ModBlocks.itemBlock("denser_neutron_compressor", BaseNeutronCompressorBlock::new, (Rarity)ModRarities.LEGEND.getValue());
    public static DeferredBlock<Block> densest_neutron_compressor = ModBlocks.itemBlock("densest_neutron_compressor", BaseNeutronCompressorBlock::new, (Rarity)ModRarities.COSMIC.getValue());
    public static DeferredBlock<Block> extreme_smithing_table = ModBlocks.itemBlock("extreme_smithing_table", ExtremeSmithingTableBlock::new, (Rarity)ModRarities.LEGEND.getValue());
    public static DeferredBlock<Block> extreme_anvil = ModBlocks.itemBlock("extreme_anvil", ExtremeAnvilBlock::new, (Rarity)ModRarities.LEGEND.getValue());
    public static DeferredBlock<Block> endless_cake = ModBlocks.itemBlock("endless_cake", EndlessCakeBlock::new, ModRarities.UNCOMMON);
    public static DeferredBlock<Block> fake_bedrock = ModBlocks.itemBlock("fake_bedrock", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1000.0f, 3600000.0f).isValidSpawn((state, level, pos, value) -> false)), false);
    public static DeferredBlock<Block> fake_end_portal_frame = ModBlocks.itemBlock("fake_end_portal_frame", () -> new EndPortalFrameBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.GLASS).lightLevel(blockState -> 1).strength(400.0f, 3600000.0f)), false);
    public static DeferredBlock<Block> fake_end_portal = ModBlocks.itemBlock("fake_end_portal", () -> new EndPortalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).noCollission().lightLevel(state -> 15).strength(400.0f, 3600000.0f).pushReaction(PushReaction.BLOCK)), false);

    private static DeferredBlock<Block> baseBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    public static DeferredBlock<Block> itemBlock(String name, Supplier<Block> block) {
        return ModBlocks.itemBlock(name, block, true);
    }

    public static DeferredBlock<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem) {
        return ModBlocks.itemBlock(name, block, hasItem, (DeferredBlock<Block> b) -> () -> new BaseBlockItem((Block)b.get(), p -> p));
    }

    public static DeferredBlock<Block> itemBlock(String name, Supplier<Block> block, Rarity rarity) {
        return ModBlocks.itemBlock(name, block, true, (DeferredBlock<Block> b) -> () -> new BaseBlockItem((Block)b.get(), p -> p.rarity(rarity)));
    }

    public static DeferredBlock<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties) {
        return ModBlocks.itemBlock(name, block, hasItem, (DeferredBlock<Block> b) -> () -> new BaseBlockItem((Block)b.get(), p -> properties));
    }

    public static DeferredBlock<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, Function<DeferredBlock<Block>, Supplier<? extends BlockItem>> item) {
        DeferredBlock reg = BLOCKS.register(name, block);
        if (hasItem) {
            BLOCK_ITEMS.put(name, () -> (BlockItem)((Supplier)item.apply(reg)).get());
        }
        return reg;
    }

    public static DeferredBlock<Block> itemBurnBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties, final int burnTime) {
        return ModBlocks.itemBlock(name, block, hasItem, (DeferredBlock<Block> b) -> () -> new BaseBlockItem((Block)b.get(), p -> properties){

            public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return burnTime;
            }
        });
    }
}

