/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry;

import committee.nova.mods.avaritia.Const;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModDamageTypes {
    public static final ResourceKey<DamageType> INFINITY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Const.rl("infinity"));

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(INFINITY, (Object)new DamageType("infinity", DamageScaling.ALWAYS, 0.1f));
    }

    public static DamageSource causeRandomDamage(Entity attacker) {
        return new DamageSourceRandomMessages((Holder<DamageType>)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(INFINITY), attacker);
    }

    public static class DamageSourceRandomMessages
    extends DamageSource {
        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, @Nullable Entity entity) {
            super(damageTypeHolder, entity);
        }

        @NotNull
        public Component getLocalizedDeathMessage(LivingEntity attacked) {
            int type = attacked.getRandom().nextInt(3);
            LivingEntity livingentity = attacked.getKillCredit();
            String s = "death.attack." + this.getMsgId() + "." + type;
            String s1 = "death.attack." + this.getMsgId() + ".player." + type;
            return livingentity != null ? Component.translatable((String)s1, (Object[])new Object[]{attacked.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s, (Object[])new Object[]{attacked.getDisplayName()});
        }
    }
}

