/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.api.utils.InventoryUtils;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import committee.nova.mods.avaritia.common.entity.EndestPearlEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenSubArrowEntity;
import committee.nova.mods.avaritia.common.entity.arrow.TraceArrowEntity;
import committee.nova.mods.avaritia.common.item.tools.InfinityArmorItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModTags;
import committee.nova.mods.avaritia.util.ClustersUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ToolUtils {
    public static final Set<TagKey<Block>> materialsPick = Sets.newHashSet((Object[])new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.STONES, Tags.Blocks.STORAGE_BLOCKS, Tags.Blocks.GLASS_BLOCKS, Tags.Blocks.ORES, BlockTags.SCULK_REPLACEABLE_WORLD_GEN, Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Blocks.COBBLESTONES_DEEPSLATE, BlockTags.FEATURES_CANNOT_REPLACE});
    public static final Set<TagKey<Block>> materialsAxe = Sets.newHashSet((Object[])new TagKey[]{BlockTags.LOGS, BlockTags.FALL_DAMAGE_RESETTING, BlockTags.LEAVES});
    public static final Set<TagKey<Block>> materialsShovel = Sets.newHashSet((Object[])new TagKey[]{BlockTags.MINEABLE_WITH_SHOVEL});
    private static final List<String> projectileAntiImmuneEntities = Lists.newArrayList((Object[])new String[]{"minecraft:enderman", "minecraft:wither", "minecraft:ender_dragon", "draconicevolution:guardian_wither"});

    public static boolean canUseTool(BlockState state, Set<TagKey<Block>> keySets) {
        return state.getTags().collect(Collectors.toSet()).retainAll(keySets);
    }

    public static void destroy(ServerLevel world, Player player, BlockPos pos) {
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        world.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)player, (BlockState)world.getBlockState(pos)));
    }

    public static boolean isPlayerWearing(LivingEntity entity, EquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.getItemBySlot(slot);
        return !stack.isEmpty() && predicate.test(stack.getItem());
    }

    public static boolean isInfinite(LivingEntity player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || !(stack = player.getItemBySlot(slot)).isEmpty() && stack.getItem() instanceof InfinityArmorItem) continue;
            return false;
        }
        return true;
    }

    public static void destroyMaterialBlocks(ServerPlayer player, BlockPos startPos, int range, Set<TagKey<Block>> materials) {
        ServerLevel world = player.serverLevel();
        int halfRange = range / 2;
        BlockPos minPos = startPos.offset(-halfRange, -halfRange, -halfRange);
        BlockPos maxPos = startPos.offset(halfRange, halfRange, halfRange);
        HashSet drops = Sets.newHashSet();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockPos currentPos = pos.immutable();
            BlockState state = world.getBlockState(currentPos);
            if (!ToolUtils.canUseTool(state, materials) || !state.getBlock().canHarvestBlock(state, (BlockGetter)world, currentPos, (Player)player)) continue;
            List blockDrops = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)currentPos, null);
            if (!blockDrops.isEmpty()) {
                drops.addAll(blockDrops);
            } else {
                ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
                if (blockItem != Items.AIR && blockItem != null) {
                    drops.add(new ItemStack((ItemLike)blockItem));
                }
            }
            world.destroyBlock(currentPos, false, (Entity)player);
            world.playSound(null, currentPos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            world.levelEvent(2001, currentPos, Block.getId((BlockState)state));
        }
        ClustersUtils.spawnClusters((Level)world, (Player)player, drops);
    }

    public static void removeBlockWithDrops(ServerLevel world, Player player, BlockPos pos, ItemStack stack, Set<ItemStack> drops, Set<TagKey<Block>> validMaterials) {
        if (!world.isLoaded(pos)) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.is(Blocks.GRASS_BLOCK) && stack.is((Item)ModItems.infinity_pickaxe.get())) {
            world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        }
        if (!block.canHarvestBlock(state, (BlockGetter)world, pos, player) || !ToolUtils.canUseTool(state, validMaterials)) {
            return;
        }
        List blockDrops = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, null);
        if (!blockDrops.isEmpty()) {
            drops.addAll(blockDrops);
        } else {
            ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
            Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
            drops.add(new ItemStack((ItemLike)blockItem));
        }
        if (!(block instanceof BaseFireBlock)) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        ToolUtils.destroy(world, player, pos);
    }

    public static void arrowBarrage(Entity shooter, Level level, List<Entity> piercedAndKilledEntities, AbstractArrow.Pickup pickup, RandomSource randy, BlockPos pos) {
        for (int i = 0; i < 50; ++i) {
            double angle = randy.nextDouble() * 9.0 * Math.PI;
            double dist = randy.nextGaussian() * 0.8;
            double x = Math.sin(angle) * dist + (double)pos.getX();
            double z = Math.cos(angle) * dist + (double)pos.getZ();
            double y = (double)pos.getY() + 25.0;
            double dangle = randy.nextDouble() * 9.0 * Math.PI;
            double dDist = randy.nextDouble() * 0.35;
            double dx = Math.sin(dangle) * dDist;
            double dz = Math.cos(dangle) * dDist;
            HeavenSubArrowEntity subArrow = new HeavenSubArrowEntity(level, shooter, x, y, z);
            subArrow.piercedAndKilledEntities = piercedAndKilledEntities;
            subArrow.push(dx, -(randy.nextDouble() * 1.85 + 0.15), dz);
            subArrow.setCritArrow(true);
            subArrow.setBaseDamage(((Integer)ModConfig.subArrowDamage.get()).intValue());
            subArrow.pickup = pickup;
            level.addFreshEntity((Entity)subArrow);
        }
    }

    public static DamageSource getArrowDamageSource(AbstractArrow arrow, Entity owner, Entity target) {
        DamageSource damagesource;
        if (owner == null) {
            damagesource = target.damageSources().arrow(arrow, (Entity)arrow);
        } else {
            damagesource = target.damageSources().arrow(arrow, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                livingEntity.setLastHurtMob(target);
            }
        }
        if (owner != null && projectileAntiImmuneEntities.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).toString())) {
            damagesource = ModDamageTypes.causeRandomDamage(owner);
        }
        return damagesource;
    }

    public static void infinityTraceArrowDamage(@NotNull EntityHitResult result, TraceArrowEntity arrow) {
        Player player;
        TraceArrowEntity owner;
        Entity entity = result.getEntity();
        if (entity instanceof Player) {
            arrow.seekNextTarget();
            return;
        }
        float f = (float)arrow.getDeltaMovement().length();
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * arrow.getBaseDamage()), (double)0.0, (double)2.147483647E9));
        TraceArrowEntity traceArrowEntity = owner = arrow.getOwner() == null ? arrow : arrow.getOwner();
        if (arrow.getPierceLevel() > 0) {
            if (arrow.piercingIgnoreEntityIds == null) {
                arrow.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (arrow.piercedAndKilledEntities == null) {
                arrow.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (arrow.piercingIgnoreEntityIds.size() >= arrow.getPierceLevel() + 1) {
                arrow.discard();
                return;
            }
            arrow.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (arrow.isCritArrow()) {
            long j = arrow.getRandom().nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        DamageSource damagesource = ToolUtils.getArrowDamageSource((AbstractArrow)arrow, (Entity)owner, entity);
        boolean isEnderman = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (arrow.isOnFire() && !isEnderman) {
            entity.setRemainingFireTicks(5);
        }
        if (entity instanceof Player && (player = (Player)entity).isUsingItem() && player.getUseItem().getItem() instanceof ShieldItem) {
            player.getCooldowns().addCooldown(player.getUseItem().getItem(), 100);
            arrow.level().broadcastEntityEvent((Entity)player, (byte)30);
            player.stopUsingItem();
        }
        if (entity.hurt(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                ServerPlayer serverPlayer;
                Level level;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!arrow.level().isClientSide && arrow.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                if ((level = arrow.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (owner instanceof LivingEntity) {
                        LivingEntity livingOwner = (LivingEntity)owner;
                        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)arrow.getWeaponItem());
                    }
                }
                arrow.doPostHurtEffects(livingentity);
                if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (!arrow.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
                if (!entity.isAlive() && arrow.piercedAndKilledEntities != null) {
                    arrow.piercedAndKilledEntities.add(livingentity);
                }
                if (!arrow.level().isClientSide && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (arrow.piercedAndKilledEntities != null && arrow.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverPlayer, (Collection)arrow.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && arrow.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverPlayer, List.of(entity));
                    }
                }
            }
            arrow.playSound(arrow.getHitGroundSoundEvent(), 1.0f, 1.2f / (arrow.getRandom().nextFloat() * 0.2f + 0.9f));
            if (arrow.getPierceLevel() <= 0) {
                arrow.setDeltaMovement(entity.getDeltaMovement().scale(0.0));
                arrow.setPos(entity.position());
                arrow.seekNextTarget();
                arrow.level().playSound(null, arrow.getX(), arrow.getY(), arrow.getZ(), SoundEvents.ARROW_HIT, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        } else {
            entity.setRemainingFireTicks(k);
            arrow.setDeltaMovement(arrow.getDeltaMovement().scale(0.0));
            arrow.setYRot(arrow.getYRot() + 180.0f);
            arrow.setPos(entity.position());
            arrow.yRotO += 180.0f;
            if (!arrow.level().isClientSide && arrow.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (arrow.pickup == AbstractArrow.Pickup.ALLOWED) {
                    arrow.spawnAtLocation(arrow.getPickupItem(), 0.1f);
                }
                arrow.seekNextTarget();
                arrow.level().playSound(null, arrow.getX(), arrow.getY(), arrow.getZ(), SoundEvents.ARROW_HIT, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        }
    }

    public static void sweepAttack(Level level, LivingEntity livingEntity, Entity victim) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (LivingEntity livingentity : level.getEntitiesOfClass(LivingEntity.class, player.getItemInHand(InteractionHand.MAIN_HAND).getSweepHitBox(player, victim))) {
                double entityReachSq = Mth.square((double)player.entityInteractionRange());
                if (player.isAlliedTo((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).isMarker() || !(player.distanceToSqr((Entity)livingentity) < entityReachSq)) continue;
                livingentity.knockback((double)0.6f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX() + d0, player.getY(0.5), player.getZ() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static void pearlAttack(Player player, ItemStack stack, Level world) {
        EndestPearlEntity pearl;
        if (!world.isClientSide && (pearl = (EndestPearlEntity)((EntityType)ModEntities.ENDER_PEARL.get()).create(player.level())) != null) {
            pearl.setItem(stack);
            pearl.setShooter((LivingEntity)player);
            pearl.setPos(player.getX(), player.getEyeY() + 0.1, player.getZ());
            pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)pearl);
            player.getCooldowns().addCooldown(stack.getItem(), 30);
        }
        world.playSound(player, player.getOnPos(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
    }

    public static void aoeAttack(Player player, float range, float damage, boolean hurtAnimal, boolean lightOn) {
        if (player.level().isClientSide) {
            return;
        }
        AABB aabb = player.getBoundingBox().deflate((double)range);
        List toAttack = player.level().getEntities((Entity)player, aabb);
        DamageSource src = ModDamageTypes.causeRandomDamage((Entity)player);
        toAttack.stream().filter(entity -> entity instanceof Mob).filter(entity -> !entity.getType().is(ModTags.NEUTRAL_CREATURES)).forEach(arg_0 -> ToolUtils.lambda$aoeAttack$2(hurtAnimal, src, damage, player, lightOn, arg_0));
    }

    public static void rangeHarvest(ServerLevel serverLevel, Player player, ItemStack stack, BlockPos blockPos, int rang, int height) {
        BlockPos minPos = blockPos.offset(-rang, -height, -rang);
        BlockPos maxPos = blockPos.offset(rang, height, rang);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            CropBlock cropBlock;
            BlockState state = serverLevel.getBlockState(pos);
            Block block = state.getBlock();
            HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
            if (block instanceof CropBlock && ((cropBlock = (CropBlock)block) instanceof BeetrootBlock ? (Integer)state.getValue((Property)BeetrootBlock.AGE) >= 3 : (Integer)state.getValue((Property)CropBlock.AGE) >= 7)) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.setBlock(pos, (BlockState)state.setValue((Property)(block instanceof BeetrootBlock ? BeetrootBlock.AGE : CropBlock.AGE), (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof CocoaBlock && (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.setBlock(pos, (BlockState)state.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof StemBlock) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            }
            if (block instanceof SweetBerryBushBlock && (Integer)state.getValue((Property)SweetBerryBushBlock.AGE) >= 3) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.setBlock(pos, (BlockState)state.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.setBlock(pos, (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0)), 11);
            }
            ClustersUtils.spawnClusters((Level)serverLevel, player, map);
        }
    }

    public static void rangeBonemealable(ServerLevel serverLevel, BlockPos blockPos, int rang, int height, int cost) {
        BlockPos minPos = blockPos.offset(-rang, -height, -rang);
        BlockPos maxPos = blockPos.offset(rang, height, rang);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState state = serverLevel.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof BonemealableBlock)) continue;
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            if (block instanceof GrassBlock || !bonemealableBlock.isValidBonemealTarget((LevelReader)serverLevel, pos, state)) continue;
            for (int i = 0; i < cost; ++i) {
                bonemealableBlock.performBonemeal(serverLevel, serverLevel.random, pos, state);
                serverLevel.levelEvent(2005, pos, 0);
            }
        }
    }

    public static boolean canHarvest(BlockPos pos, Level world) {
        if (!ToolUtils.isLogOrLeaves(world, pos)) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        if (state.getProperties().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.AXIS))) {
            return ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)).equals((Object)Direction.Axis.Y);
        }
        return true;
    }

    public static void destroyTree(Player player, ServerLevel world, BlockPos pos, BlockState state) {
        List<BlockPos> connectedLogs = ToolUtils.getConnectedLogs((Level)world, pos);
        HashSet drops = Sets.newHashSet();
        for (BlockPos logPos : connectedLogs) {
            List blockDrops = Block.getDrops((BlockState)world.getBlockState(logPos), (ServerLevel)world, (BlockPos)logPos, null);
            if (!blockDrops.isEmpty()) {
                drops.addAll(blockDrops);
            } else {
                ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(logPos).getBlock());
                Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
                drops.add(new ItemStack((ItemLike)blockItem));
            }
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            ToolUtils.destroy(world, player, logPos);
        }
        ClustersUtils.spawnClusters((Level)world, player, drops);
    }

    private static List<BlockPos> getConnectedLogs(Level world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        ToolUtils.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(Level world, BlockPos pos, BlockPosList positions) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.offset(x, y, z);
                    if (!ToolUtils.isLogOrLeaves(world, p) || !positions.add(p)) continue;
                    posList.add(p);
                }
            }
        }
        for (BlockPos p : posList) {
            ToolUtils.collectLogs(world, p, positions);
        }
    }

    private static boolean isLogOrLeaves(Level world, BlockPos pos) {
        BlockState b = world.getBlockState(pos);
        return b.is(BlockTags.LOGS) || b.is(BlockTags.LEAVES);
    }

    public static ItemStack getPlayerTotemItem(Player player) {
        return InventoryUtils.findItemInInv(player, stack -> stack.is((Item)ModItems.infinity_totem.get()), stack -> stack);
    }

    public static void melting(BlockState state, Level world, BlockPos pos, Player player, ItemStack tool) {
        boolean flag;
        if (!state.getBlock().canHarvestBlock(state, (BlockGetter)world, pos, player) || state.getBlock() instanceof CropBlock) {
            return;
        }
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null);
        Holder.Reference fortune = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        int unLuck = EnchantmentHelper.getTagEnchantmentLevel((Holder)fortune, (ItemStack)tool);
        boolean bl = flag = unLuck > 0 && world.random.nextDouble() < (double)unLuck * 0.2;
        if (drops.isEmpty() || flag) {
            return;
        }
        drops.forEach(itemStack -> {
            ItemStack dropStack = ToolUtils.getMeltingItem(player, world, itemStack, tool);
            if (!dropStack.equals(itemStack)) {
                ToolUtils.meltingAchieve(world, player, pos);
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, dropStack));
            }
        });
    }

    public static ItemStack getMeltingItem(Player player, Level world, ItemStack itemStack, ItemStack tool) {
        ItemStack dropStack = world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(itemStack), world).map(smeltingRecipe -> ((SmeltingRecipe)smeltingRecipe.value()).getResultItem((HolderLookup.Provider)world.registryAccess())).filter(e -> !e.isEmpty()).map(e -> e.copyWithCount(tool.getCount() * e.getCount())).orElse(itemStack);
        Holder.Reference fortuneEnchant = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        int fortune = EnchantmentHelper.getTagEnchantmentLevel((Holder)fortuneEnchant, (ItemStack)tool);
        if (fortune > 0) {
            RandomSource random = RandomSource.create();
            int count = 1;
            if (random.nextDouble() < 0.3 + (double)fortune * 0.1) {
                count += Mth.nextInt((RandomSource)random, (int)0, (int)(fortune + 1));
            }
            if (random.nextDouble() < 0.1 + (double)fortune * 0.05) {
                count *= Mth.nextInt((RandomSource)random, (int)1, (int)fortune);
            }
            dropStack.setCount(count);
        }
        return dropStack;
    }

    public static void meltingAchieve(Level world, Player player, BlockPos pos) {
        if (!world.isClientSide) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (int i = 0; i < 10; ++i) {
                serverWorld.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + world.random.nextDouble(), (double)pos.getY() + 1.0, (double)pos.getZ() + world.random.nextDouble(), 1.0, 0.0, 0.0);
            }
        }
        world.playSound(player, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    public static void shootBladeSlash(ItemStack stack, Player player) {
        Level world = player.level();
        Holder.Reference sweeping_edge = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SWEEPING_EDGE);
        BladeSlashEntity projectile = new BladeSlashEntity(world, (LivingEntity)player, EnchantmentHelper.getTagEnchantmentLevel((Holder)sweeping_edge, (ItemStack)stack));
        world.addFreshEntity((Entity)projectile);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
        player.swing(player.getUsedItemHand());
    }

    public static void speedBlockTick(BlockPos pos, ServerLevel level, int speed, int randomTicks) {
        BlockEntity blockEntity;
        int random_tick_rate = 4;
        BlockState targetState = level.getBlockState(pos);
        Block targetBlock = targetState.getBlock();
        if (!(targetBlock instanceof EntityBlock)) {
            return;
        }
        EntityBlock entityBlock = (EntityBlock)targetBlock;
        if (level instanceof ServerLevel && targetBlock.isRandomlyTicking && level.getRandom().nextInt(Mth.clamp((int)(4096 / (speed * random_tick_rate)), (int)1, (int)4096)) < randomTicks) {
            targetState.randomTick(level, pos, level.getRandom());
        }
        if ((blockEntity = level.getBlockEntity(pos)) != null) {
            BlockEntityTicker ticker = entityBlock.getTicker((Level)level, targetState, blockEntity.getType());
            if (blockEntity.isRemoved() || ticker == null) {
                return;
            }
            for (int i = 0; i < speed && !blockEntity.isRemoved(); ++i) {
                ticker.tick((Level)level, pos, targetState, blockEntity);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$aoeAttack$2(boolean hurtAnimal, DamageSource src, float damage, Player player, boolean lightOn, Entity entity) {
        block8: {
            if (!(entity instanceof Mob)) break block8;
            mob = (Mob)entity;
            if (!(mob instanceof Animal)) ** GOTO lbl-1000
            animal = (Animal)mob;
            if (hurtAnimal) {
                animal.hurt(src, damage);
            } else if (mob instanceof EnderDragon) {
                dragon = (EnderDragon)mob;
                dragon.setHealth(0.0f);
            } else if (mob instanceof WitherBoss) {
                wither = (WitherBoss)mob;
                wither.setInvulnerableTicks(0);
                wither.hurt(src, damage);
            } else if (!(mob instanceof Animal)) {
                mob.hurt(src, damage);
            }
        }
        lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(player.level());
        if (!(!lightOn || lightningbolt == null || entity instanceof Animal && hurtAnimal)) {
            lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)entity.blockPosition()));
            lightningbolt.setCause(player instanceof ServerPlayer != false ? (serverPlayer = (ServerPlayer)player) : null);
            player.level().addFreshEntity((Entity)lightningbolt);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

