/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.client.gui.SearchBar;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class ListParticleWidgetProvider
extends ParticleConfigWidgetProvider {
    public List<DocEntryButton> buttons;
    public GuiImageButton upButton;
    public GuiImageButton downButton;
    public int pageOffset;
    public int maxEntries;
    public int numPerPage = 8;
    public SearchBar searchBar;
    public String previousSearch = "";
    private Supplier<Map<String, Object>> preservedData;

    public ListParticleWidgetProvider(int x, int y, int width, int height, List<DocEntryButton> buttons, int numPerPage, Supplier<Map<String, Object>> providerData) {
        super(x, y, width, height);
        this.buttons = buttons;
        this.maxEntries = buttons.size();
        this.numPerPage = numPerPage;
        this.preservedData = providerData;
        Map<String, Object> data = providerData.get();
        if (!data.isEmpty()) {
            if (data.containsKey("search")) {
                this.previousSearch = (String)data.get("search");
            }
            if (data.containsKey("pageOffset")) {
                this.pageOffset = (Integer)data.get("pageOffset");
            }
            if (data.containsKey("maxEntries")) {
                this.maxEntries = (Integer)data.get("maxEntries");
            }
        }
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollY < 0.0) {
            this.onScroll(1);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollY > 0.0) {
            this.onScroll(-1);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void onScroll(int offset) {
        this.pageOffset += this.numPerPage * offset;
        this.pageOffset = Math.max(0, Math.min(this.pageOffset, this.maxEntries - this.numPerPage));
        this.preservedData.get().put("pageOffset", this.pageOffset);
        this.updateButtons();
    }

    public List<DocEntryButton> filter(String filterText) {
        if (filterText == null || filterText.isEmpty()) {
            return this.buttons;
        }
        String lowerFilter = filterText.toLowerCase(Locale.ROOT);
        return this.buttons.stream().filter((? super T button) -> button.title.getString().toLowerCase(Locale.ROOT).contains(lowerFilter)).toList();
    }

    protected void updateButtons() {
        boolean hasFewer;
        List<DocEntryButton> filteredButtons = this.filter(this.searchBar.value);
        this.maxEntries = filteredButtons.size();
        this.preservedData.get().put("maxEntries", this.maxEntries);
        for (DocEntryButton button : this.buttons) {
            button.active = false;
            button.visible = false;
            button.setPosition(-100, -100);
        }
        List<DocEntryButton> sublist = filteredButtons.subList(this.pageOffset, Math.min(filteredButtons.size(), this.pageOffset + this.numPerPage));
        for (int i = 0; i < sublist.size(); ++i) {
            int x = this.x;
            int y = this.y + 20 + 15 * (i % 8);
            Button button = sublist.get(i);
            button.visible = true;
            button.active = true;
            button.setPosition(x, y);
        }
        boolean hasMore = this.pageOffset + this.numPerPage < this.maxEntries;
        this.upButton.visible = hasFewer = this.pageOffset > 0;
        this.upButton.active = hasFewer;
        this.downButton.active = hasMore;
        this.downButton.visible = hasMore;
    }

    public void onSearchChanged(String search) {
        if (search.equals(this.previousSearch)) {
            return;
        }
        this.pageOffset = 0;
        this.previousSearch = search;
        this.preservedData.get().put("search", search);
        this.preservedData.get().put("pageOffset", this.pageOffset);
        this.updateButtons();
    }

    @Override
    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    @Override
    public void addWidgets(List<AbstractWidget> widgets) {
        this.searchBar = new SearchBar(Minecraft.getInstance().font, this.x + 11, this.y - 19);
        if (this.previousSearch != null) {
            this.searchBar.setValue(this.previousSearch);
        }
        this.searchBar.setResponder(this::onSearchChanged);
        for (Button button2 : this.buttons) {
            widgets.add((AbstractWidget)button2);
        }
        int arrowY = this.y + this.height - 5 - (8 - this.numPerPage) * 15;
        this.upButton = new GuiImageButton(this.x + 80, arrowY, DocAssets.BUTTON_UP, button -> this.onScroll(-1)).withHoverImage(DocAssets.BUTTON_UP_HOVER);
        this.downButton = new GuiImageButton(this.x + 100, arrowY, DocAssets.BUTTON_DOWN, button -> this.onScroll(1)).withHoverImage(DocAssets.BUTTON_DOWN_HOVER);
        widgets.add((AbstractWidget)this.upButton);
        widgets.add((AbstractWidget)this.downButton);
        if (this.buttons.size() > this.numPerPage) {
            widgets.add((AbstractWidget)this.searchBar);
        }
        this.updateButtons();
    }
}

