/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.BookSlider;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.HSLColor;
import com.hollingsworth.arsnouveau.client.gui.HueSlider;
import com.hollingsworth.arsnouveau.client.gui.SatLumSlider;
import com.hollingsworth.arsnouveau.client.gui.buttons.ColorPresetButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectedParticleButton;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.RainbowParticleColor;
import com.hollingsworth.nuggets.client.gui.NoShadowTextField;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class ColorProperty
extends BaseProperty<ColorProperty> {
    public static MapCodec<ColorProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleColor.CODEC.fieldOf("particleColor").forGetter(i -> i.particleColor), (App)Codec.BOOL.fieldOf("tintDisabled").orElse((Object)false).forGetter(i -> i.tintDisabled)).apply((Applicative)instance, ColorProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, ColorProperty> STREAM_CODEC = StreamCodec.composite(ParticleColor.STREAM, i -> i.particleColor, (StreamCodec)ByteBufCodecs.BOOL, ColorProperty::isTintDisabled, ColorProperty::new);
    public ParticleColor particleColor;
    public boolean isLegacyRGB = false;
    boolean tintDisabled = false;
    private ParticleColor displayColor;

    public ColorProperty(ParticleColor property, boolean tintDisabled) {
        this.particleColor = property;
        this.tintDisabled = tintDisabled;
        this.displayColor = this.particleColor;
    }

    public ColorProperty() {
        this(ParticleColor.defaultParticleColor(), true);
    }

    public ParticleColor color() {
        return this.tintDisabled ? ParticleColor.WHITE : this.particleColor;
    }

    public boolean isTintDisabled() {
        return this.tintDisabled;
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        final ColorProperty property = this;
        return new ParticleConfigWidgetProvider(x, y, width, height){
            BookSlider redW;
            BookSlider greenW;
            BookSlider blueW;
            HueSlider hueSlider;
            SatLumSlider saturation;
            SatLumSlider lightness;
            SelectedParticleButton rainbowButton;
            SelectedParticleButton noneButton;
            List<SelectedParticleButton> selectableButtons;
            NoShadowTextField textField;
            {
                super(x, y, width, height);
                this.selectableButtons = new ArrayList<SelectedParticleButton>();
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(ColorProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
                int xOffset = this.x + 7;
                int yOffset = this.y + 18;
                DocClientUtils.blit(graphics, DocAssets.SPELLSTYLE_COLOR_PREVIEW, xOffset, yOffset);
                int hueOffset = 35;
                DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.hue"), graphics, this.x + 8, this.y + hueOffset, this.width, mouseX, mouseY, partialTicks);
                DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.sat"), graphics, this.x + 8, this.y + hueOffset + 20, this.width, mouseX, mouseY, partialTicks);
                DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.lightness"), graphics, this.x + 8, this.y + hueOffset + 40, this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void renderBg(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.renderBg(graphics, mouseX, mouseY, partialTicks);
                Color color = new Color(ColorProperty.this.displayColor.getColor(), false);
                int xOffset = 160;
                int yOffset = 35;
                graphics.fill(xOffset + 2, yOffset + 3, xOffset - 2 + DocAssets.SPELLSTYLE_COLOR_PREVIEW.width(), yOffset - 3 + DocAssets.SPELLSTYLE_COLOR_PREVIEW.height(), color.getRGB());
                graphics.fill(xOffset + 3, yOffset + 2, xOffset - 3 + DocAssets.SPELLSTYLE_COLOR_PREVIEW.width(), yOffset - 2 + DocAssets.SPELLSTYLE_COLOR_PREVIEW.height(), color.getRGB());
            }

            @Override
            public void tick() {
                super.tick();
                if (ColorProperty.this.displayColor != null) {
                    ColorProperty.this.displayColor = ColorProperty.this.displayColor.transition(ClientInfo.ticksInGame);
                }
            }

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                Consumer<Double> colorChanged = value -> {
                    ParticleColor color;
                    ColorProperty.this.displayColor = ColorProperty.this.particleColor = (color = new ParticleColor((int)this.redW.getValue(), (int)this.greenW.getValue(), (int)this.blueW.getValue()));
                    ColorProperty.this.propertyHolder.set(ColorProperty.this.getType(), property);
                };
                int hueOffset = 45;
                this.redW = this.buildSlider(this.x + 10, this.y + hueOffset - 5, (Component)Component.translatable((String)"ars_nouveau.color_gui.red_slider"), (Component)Component.empty(), 255.0, colorChanged);
                this.greenW = this.buildSlider(this.x + 10, this.y + hueOffset + 15, (Component)Component.translatable((String)"ars_nouveau.color_gui.green_slider"), (Component)Component.empty(), 25.0, colorChanged);
                this.blueW = this.buildSlider(this.x + 10, this.y + hueOffset + 36, (Component)Component.translatable((String)"ars_nouveau.color_gui.blue_slider"), (Component)Component.empty(), 180.0, colorChanged);
                int xOffset = 7;
                this.hueSlider = new HueSlider(this.x + xOffset, this.y + hueOffset, false, () -> HSLColor.hsl(this.hueSlider.getValueInt(), this.saturation.getValue(), this.lightness.getValue()), val -> this.updateParticleColor());
                this.saturation = new SatLumSlider(this.x + xOffset, this.y + hueOffset + 20, false, false, () -> HSLColor.hsl(this.hueSlider.getValueInt(), this.saturation.getValue(), this.lightness.getValue()), val -> this.updateParticleColor());
                this.lightness = new SatLumSlider(this.x + xOffset, this.y + hueOffset + 40, false, true, () -> HSLColor.hsl(this.hueSlider.getValueInt(), this.saturation.getValue(), this.lightness.getValue()), val -> this.updateParticleColor());
                this.textField = new NoShadowTextField(Minecraft.getInstance().font, this.x + xOffset, this.y + 17, 100, 20, (Component)Component.empty());
                this.textField.setResponder(val -> {
                    if (val.length() == 7) {
                        ParticleColor color = ParticleColor.fromHex(val);
                        this.setFromPreset(color);
                        this.updateParticleColor();
                    }
                });
                this.setFromPreset(ColorProperty.this.particleColor);
                int numPerRow = 6;
                int size = ParticleColor.PRESET_COLORS.size();
                for (int i = 0; i < size; ++i) {
                    ParticleColor color = ParticleColor.PRESET_COLORS.get(i);
                    ColorPresetButton button2 = new ColorPresetButton(this.x + xOffset + i % numPerRow * 18, this.y + 100 + i / numPerRow * 18, color, b -> {
                        this.setFromPreset(color);
                        this.updateParticleColor();
                    });
                    this.selectableButtons.add(button2);
                    widgets.add((AbstractWidget)button2);
                }
                this.rainbowButton = new SelectedParticleButton(this, this.x + xOffset + size % numPerRow * 18, this.y + 100 + size / numPerRow * 18, DocAssets.SPELLSTYLE_RAINBOW, button -> {
                    ColorProperty.this.displayColor = ColorProperty.this.particleColor = new RainbowParticleColor(ColorProperty.this.particleColor.getRedInt(), ColorProperty.this.particleColor.getGreenInt(), ColorProperty.this.particleColor.getBlueInt());
                    ColorProperty.this.tintDisabled = false;
                    ColorProperty.this.propertyHolder.set(ColorProperty.this.getType(), property);
                }){

                    @Override
                    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                        DocClientUtils.blit(graphics, DocAssets.SPELLSTYLE_BUTTON_BIG, this.x, this.y);
                        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
                    }
                };
                this.noneButton = new SelectedParticleButton(this.x + xOffset + ++size % numPerRow * 18, this.y + 100 + size / numPerRow * 18, DocAssets.STYLE_ICON_NONE, button -> {
                    ColorProperty.this.tintDisabled = true;
                    ColorProperty.this.displayColor = ColorProperty.this.particleColor = ParticleColor.WHITE;
                    ColorProperty.this.propertyHolder.set(ColorProperty.this.getType(), property);
                });
                this.rainbowButton.withTooltip((Component)Component.translatable((String)"ars_nouveau.color_rainbow"));
                this.noneButton.withTooltip((Component)Component.translatable((String)"ars_nouveau.color_none"));
                this.selectableButtons.add(this.noneButton);
                this.selectableButtons.add(this.rainbowButton);
                this.textField.setValue(ColorProperty.this.displayColor.toHex());
                this.textField.textColor = ColorProperty.this.displayColor.getOppositeColor().getColor();
                this.textField.setMaxLength(7);
                this.textField.setFilter(s -> {
                    if (!s.startsWith("#")) {
                        return false;
                    }
                    if (s.length() > 7) {
                        return false;
                    }
                    if (s.length() < 7) {
                        return true;
                    }
                    try {
                        ParticleColor.fromHex(s);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
                widgets.add((AbstractWidget)this.rainbowButton);
                widgets.add((AbstractWidget)this.textField);
                widgets.add((AbstractWidget)this.hueSlider);
                widgets.add((AbstractWidget)this.saturation);
                widgets.add((AbstractWidget)this.lightness);
                if (!ColorProperty.this.isLegacyRGB) {
                    widgets.add((AbstractWidget)this.noneButton);
                }
            }

            public void updateParticleColor() {
                ColorProperty.this.tintDisabled = false;
                ColorProperty.this.displayColor = ColorProperty.this.particleColor = HSLColor.hsl(this.hueSlider.getValueInt(), this.saturation.getValue(), this.lightness.getValue()).toColor().toParticle();
                ColorProperty.this.propertyHolder.set(ColorProperty.this.getType(), property);
                this.textField.setTextColor(ColorProperty.this.displayColor.getOppositeColor().getColor());
                if (!this.textField.value.equals(ColorProperty.this.displayColor.toHex())) {
                    this.textField.value = ColorProperty.this.displayColor.toHex();
                }
            }

            public void setFromPreset(ParticleColor preset) {
                this.redW.setValue(Mth.clamp((double)((double)preset.getRed() * 255.0), (double)1.0, (double)255.0));
                this.greenW.setValue(Mth.clamp((double)((double)preset.getGreen() * 255.0), (double)1.0, (double)255.0));
                this.blueW.setValue(Mth.clamp((double)((double)preset.getBlue() * 255.0), (double)1.0, (double)255.0));
                HSLColor color = HSLColor.rgb(preset.getRedInt(), preset.getGreenInt(), preset.getBlueInt());
                this.hueSlider.setValue(color.getHue());
                this.saturation.setValue(color.getSaturation());
                this.lightness.setValue(color.getLightness());
                ColorProperty.this.tintDisabled = false;
            }

            public BookSlider buildSlider(int x, int y, Component prefix, Component suffix, double currentVal, Consumer<Double> onValueChange) {
                return new BookSlider(x, y, 100, 20, prefix, suffix, 1.0, 255.0, currentVal, 1.0, 1, false, onValueChange);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                if (!ColorProperty.this.isLegacyRGB && ColorProperty.this.tintDisabled) {
                    DocClientUtils.blit(graphics, DocAssets.STYLE_ICON_NONE, x, y);
                    return;
                }
                Color color = new Color(ColorProperty.this.displayColor.getColor(), false);
                graphics.fill(x + 3, y + 2, x + 11, y + 3, color.getRGB());
                graphics.fill(x + 2, y + 3, x + 12, y + 11, color.getRGB());
                graphics.fill(x + 3, y + 11, x + 11, y + 12, color.getRGB());
            }

            @Override
            public Component getButtonTitle() {
                return ColorProperty.this.getName();
            }
        };
    }

    @Override
    public IPropertyType<ColorProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.COLOR_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorProperty property = (ColorProperty)o;
        return Objects.equals(this.particleColor, property.particleColor) && this.tintDisabled == property.tintDisabled;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.particleColor, this.tintDisabled);
    }
}

