/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BigTreeFeature
implements IPlaceableFeature {
    BlockState tree;
    double distance;
    double chance;

    public BigTreeFeature(BlockState tree, double distance, double chance) {
        this.tree = tree;
        this.distance = distance;
        this.chance = chance;
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        if ((double)level.random.nextFloat() < this.chance && this.validPos(level, pos) && this.validPos(level, pos.north()) && this.validPos(level, pos.north().east()) && this.validPos(level, pos.east())) {
            SaplingBlock saplingBlock;
            level.setBlock(pos, this.tree, 2);
            level.setBlock(pos.north(), this.tree, 2);
            level.setBlock(pos.north().east(), this.tree, 2);
            level.setBlock(pos.east(), this.tree, 2);
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof SaplingBlock) {
                saplingBlock = (SaplingBlock)block;
                saplingBlock.advanceTree((ServerLevel)level, pos, level.getBlockState(pos), level.random);
            }
            if ((block = level.getBlockState(pos).getBlock()) instanceof SaplingBlock) {
                saplingBlock = (SaplingBlock)block;
                saplingBlock.advanceTree((ServerLevel)level, pos, level.getBlockState(pos), level.random);
            }
            return true;
        }
        return false;
    }

    public boolean validPos(Level level, BlockPos pos) {
        return level.getBlockState(pos).canBeReplaced() && this.tree.canSurvive((LevelReader)level, pos);
    }

    @Override
    public String getFeatureName() {
        return "random_tree";
    }
}

