/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class NearbyPlayerCache {
    private static final Map<String, Cache<Long, CacheResult>> levelPlayerCache = new ConcurrentHashMap<String, Cache<Long, CacheResult>>();

    public static boolean isPlayerNearby(BlockPos pos, ServerLevel level, int range) {
        String key = level.dimension().location().toString();
        if (!levelPlayerCache.containsKey(key)) {
            levelPlayerCache.put(key, (Cache<Long, CacheResult>)CacheBuilder.newBuilder().maximumSize(1000L).build());
        }
        Cache<Long, CacheResult> positionCache = levelPlayerCache.get(key);
        long posLong = pos.asLong();
        CacheResult playerResult = (CacheResult)positionCache.getIfPresent((Object)posLong);
        long gameTime = level.getGameTime();
        if (playerResult != null && playerResult.nextCheck > gameTime) {
            return playerResult.isPlayerNearby();
        }
        long nextCheck = gameTime + 500L + (long)level.random.nextInt(20);
        for (Player player : level.players()) {
            if (!(BlockUtil.distanceFrom(player.blockPosition(), pos) < (double)range)) continue;
            positionCache.put((Object)posLong, (Object)new CacheResult(true, nextCheck));
            return true;
        }
        positionCache.put((Object)posLong, (Object)new CacheResult(false, nextCheck));
        return false;
    }

    private record CacheResult(boolean isPlayerNearby, long nextCheck) {
    }
}

