/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GuiManaHUD {
    public static final LayeredDraw.Layer OVERLAY = GuiManaHUD::renderOverlay;
    private static final Minecraft minecraft = Minecraft.getInstance();
    public static final Color BLACK = new Color(35, 35, 35).setImmutable();
    static boolean stillBar = true;

    public static boolean shouldDisplayBar() {
        IDisplayMana iDisplayManaOffhand;
        IDisplayMana iDisplayMana;
        if (Minecraft.getInstance().options.hideGui) {
            return false;
        }
        ItemStack mainHand = GuiManaHUD.minecraft.player.getMainHandItem();
        ItemStack offHand = GuiManaHUD.minecraft.player.getOffhandItem();
        Item item = mainHand.getItem();
        boolean isMainDisplayable = item instanceof IDisplayMana && (iDisplayMana = (IDisplayMana)item).shouldDisplay(mainHand);
        Item item2 = offHand.getItem();
        boolean isOffhandDisplayable = item2 instanceof IDisplayMana && (iDisplayManaOffhand = (IDisplayMana)item2).shouldDisplay(offHand);
        ManaCap cap = CapabilityRegistry.getMana((LivingEntity)GuiManaHUD.minecraft.player);
        boolean isRegenerating = false;
        if (cap != null) {
            isRegenerating = (double)cap.getMaxMana() > cap.getCurrentMana();
        }
        return isMainDisplayable || isOffhandDisplayable || isRegenerating;
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!GuiManaHUD.shouldDisplayBar()) {
            return;
        }
        PoseStack ms = guiGraphics.pose();
        ManaCap mana = CapabilityRegistry.getMana((LivingEntity)GuiManaHUD.minecraft.player);
        if (mana == null) {
            return;
        }
        int maxMana = mana.getMaxMana();
        if (maxMana == 0) {
            return;
        }
        int offsetLeft = 10 + (Integer)Config.MANABAR_X_OFFSET.get();
        int manaLength = 96;
        manaLength = (int)((double)manaLength * (mana.getCurrentMana() / ((double)maxMana * (1.0 + (double)ClientInfo.reservedOverlayMana))));
        int yOffset = minecraft.getWindow().getGuiScaledHeight() - 5 + (Integer)Config.MANABAR_Y_OFFSET.get();
        guiGraphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 18, 0.0f, 0.0f, 108, 18, 256, 256);
        int manaOffset = (int)(((float)ClientInfo.ticksInGame + deltaTracker.getGameTimeDeltaTicks()) / 3.0f % 33.0f) * 6;
        guiGraphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_mana.png"), offsetLeft + 9, yOffset - 9, 0.0f, (float)manaOffset, manaLength, 6, 256, 256);
        GuiManaHUD.renderReserveOverlay(ms, offsetLeft, yOffset, manaOffset, maxMana);
        GuiManaHUD.renderRedOverlay(ms, offsetLeft, yOffset, manaOffset, maxMana);
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS) {
            String text = (int)mana.getCurrentMana() + "  /  " + maxMana;
            int maxWidth = GuiManaHUD.minecraft.font.width(maxMana + "  /  " + maxMana);
            int offset = 67 - maxWidth / 2 + (maxWidth - GuiManaHUD.minecraft.font.width(text));
            guiGraphics.drawString(GuiManaHUD.minecraft.font, text, offset, yOffset - 10, 0xFFFFFF);
        }
        guiGraphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 17, 0.0f, 18.0f, 108, 20, 256, 256);
    }

    public static void renderRedOverlay(PoseStack ms, int offsetLeft, int yOffset, int manaOffset, int maxMana) {
        if (!ClientInfo.redTicks()) {
            return;
        }
        int redManaLength = (int)(98.0f * Mth.clamp((float)0.0f, (float)(ClientInfo.redOverlayMana / (float)maxMana), (float)1.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ArsNouveau.prefix("textures/gui/manabar_gui_grayscale.png"));
        RenderUtils.colorBlit(ms, offsetLeft + 8, yOffset - 10, 0, manaOffset, redManaLength, 8, 256, 256, Color.RED.scaleAlpha((float)ClientInfo.redOverlayTicks / 35.0f));
    }

    public static void renderReserveOverlay(PoseStack ms, int offsetLeft, int yOffset, int manaOffset, int maxMana) {
        if (ClientInfo.reservedOverlayMana <= 0.0f) {
            return;
        }
        int reserveManaLength = (int)(96.0f * ClientInfo.reservedOverlayMana);
        int offset = 96 - reserveManaLength;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ArsNouveau.prefix("textures/gui/manabar_gui_mana.png"));
        RenderUtils.colorBlit(ms, offsetLeft + 10 + offset, yOffset - 10, 0, stillBar ? 0 : manaOffset, reserveManaLength, 8, 256, 256, BLACK);
    }
}

