/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DummyCapeLayer
extends RenderLayer<EntityDummy, PlayerModel<EntityDummy>> {
    public DummyCapeLayer(RenderLayerParent<EntityDummy, PlayerModel<EntityDummy>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, EntityDummy livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Player player = livingEntity.level.getPlayerByUUID(livingEntity.getOwnerUUID());
        if (player == null) {
            return;
        }
        if (!livingEntity.isInvisible()) {
            PlayerSkin playerskin = livingEntity.getPlayerInfo().getSkin();
            ItemStack itemstack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
            if (!itemstack.is(Items.ELYTRA)) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 0.125f);
                double d0 = Mth.lerp((double)partialTicks, (double)livingEntity.xCloakO, (double)livingEntity.xCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.xo, (double)livingEntity.getX());
                double d1 = Mth.lerp((double)partialTicks, (double)livingEntity.yCloakO, (double)livingEntity.yCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.yo, (double)livingEntity.getY());
                double d2 = Mth.lerp((double)partialTicks, (double)livingEntity.zCloakO, (double)livingEntity.zCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.zo, (double)livingEntity.getZ());
                float f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
                double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
                double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
                float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = Mth.lerp((float)partialTicks, (float)livingEntity.oBob, (float)livingEntity.bob);
                f1 += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)livingEntity.walkDistO, (float)livingEntity.walkDist) * 6.0f)) * 32.0f * f4;
                if (livingEntity.isCrouching()) {
                    f1 += 25.0f;
                }
                poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
                poseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
                VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"")));
                ((PlayerModel)this.getParentModel()).renderCloak(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
    }
}

