/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.RainbowParticleColor;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@Deprecated(forRemoval=true)
public abstract class ColoredProjectile
extends Projectile {
    public static final EntityDataAccessor<Integer> RED = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> GREEN = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> BLUE = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<CompoundTag> PARTICLE_TAG = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public int rainbowStartTick = 0;
    private ParticleColor color;

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn) {
        super(type, worldIn);
        this.rainbowStartTick = this.level.random.nextInt(1536);
    }

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.setPos(x, y, z);
    }

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn, LivingEntity shooter) {
        this(type, worldIn);
        this.setOwner((Entity)shooter);
    }

    public ParticleColor getColor() {
        if (this.color == null) {
            this.color = ParticleColorRegistry.from((CompoundTag)this.entityData.get(PARTICLE_TAG));
        }
        return this.color;
    }

    public ParticleColor getParticleColor() {
        return this.getColor().transition(this.tickCount * 50);
    }

    @Deprecated(forRemoval=true)
    public boolean isRainbow() {
        return this.getParticleColor() instanceof RainbowParticleColor;
    }

    @Deprecated(forRemoval=true)
    public ParticleColor.IntWrapper getParticleColorWrapper() {
        return new ParticleColor.IntWrapper((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE));
    }

    public void setColor(ParticleColor colors) {
        ParticleColor.IntWrapper wrapper = colors.toWrapper();
        this.entityData.set(RED, (Object)wrapper.r);
        this.entityData.set(GREEN, (Object)wrapper.g);
        this.entityData.set(BLUE, (Object)wrapper.b);
        this.entityData.set(PARTICLE_TAG, (Object)colors.serialize());
        this.color = colors;
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.color = null;
        this.entityData.set(RED, (Object)compound.getInt("red"));
        this.entityData.set(GREEN, (Object)compound.getInt("green"));
        this.entityData.set(BLUE, (Object)compound.getInt("blue"));
        this.entityData.set(PARTICLE_TAG, (Object)compound.getCompound("particle"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("red", ((Integer)this.entityData.get(RED)).intValue());
        compound.putInt("green", ((Integer)this.entityData.get(GREEN)).intValue());
        compound.putInt("blue", ((Integer)this.entityData.get(BLUE)).intValue());
        compound.put("particle", (Tag)this.entityData.get(PARTICLE_TAG));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(RED, (Object)255);
        pBuilder.define(GREEN, (Object)25);
        pBuilder.define(BLUE, (Object)180);
        pBuilder.define(PARTICLE_TAG, (Object)new ParticleColor(255, 25, 180).serialize());
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level, (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }
}

