/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.scrying.IScryer;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketGetPersistentData;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class ScryEvents {
    @SubscribeEvent
    public static void playerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level.isClientSide && event.getEntity().hasEffect(ModPotions.SCRYING_EFFECT)) {
            CompoundTag tag = event.getEntity().getPersistentData().getCompound("PlayerPersisted");
            Networking.sendToPlayerClient(new PacketGetPersistentData(tag), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(PlayerTickEvent.Post event) {
        if (event.getEntity().level.isClientSide && event.getEntity().getEffect(ModPotions.SCRYING_EFFECT) != null && ClientInfo.ticksInGame % 30 == 0) {
            ArrayList<BlockPos> scryingPos = new ArrayList<BlockPos>();
            CompoundTag tag = ClientInfo.persistentData;
            if (!tag.contains("an_scryer")) {
                return;
            }
            IScryer scryer = ArsNouveauAPI.getInstance().getScryer(ResourceLocation.tryParse((String)tag.getCompound("an_scryer").getString("id"))).fromTag(tag.getCompound("an_scryer"));
            if (scryer == null) {
                return;
            }
            Player playerEntity = event.getEntity();
            Level world = playerEntity.level;
            Vec3i scrySize = scryer.getScryingSize();
            for (BlockPos p : BlockPos.withinManhattan((BlockPos)playerEntity.blockPosition(), (int)scrySize.getX(), (int)scrySize.getY(), (int)scrySize.getZ())) {
                if (world.isOutsideBuildHeight(p) || world.getBlockState(p).isAir()) continue;
                if (scryingPos.size() >= scryer.getScryMax()) break;
                if (!scryer.shouldRevealBlock(world.getBlockState(p), p, playerEntity)) continue;
                scryingPos.add(new BlockPos((Vec3i)p));
            }
            ClientInfo.scryingPositions = scryingPos;
        }
    }

    @SubscribeEvent
    public static void onRenderHighlights(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (ClientInfo.highlightTicks > 0) {
            --ClientInfo.highlightTicks;
            for (ColorPos pos : ClientInfo.highlightPositions) {
                double xzOffset = 0.15;
                double xOffset = ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0) + 0.5;
                double zOffset = ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0) + 0.5;
                double centerX = pos.pos.x + xOffset;
                double centerZ = pos.pos.x + zOffset;
                double xSpeedOffset = 0.0;
                double ySpeedOffset = ParticleUtil.inRange(0.0, 0.03f);
                double zSpeedOffset = 0.0;
                xSpeedOffset = ParticleUtil.inRange(-0.01f, 0.01f);
                zSpeedOffset = ParticleUtil.inRange(-0.01f, 0.01f);
                Vec3 renderPos = pos.pos;
                ParticleColor color = pos.color;
                world.addAlwaysVisibleParticle(GlowParticleData.createData(color, true), false, renderPos.x, renderPos.y + ParticleUtil.inRange(-0.0, 0.1), renderPos.z, xSpeedOffset, ySpeedOffset, zSpeedOffset);
            }
        }
    }

    @SubscribeEvent
    public static void renderScry(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        LocalPlayer playerEntity = Minecraft.getInstance().player;
        if (playerEntity == null || playerEntity.getEffect(ModPotions.SCRYING_EFFECT) == null) {
            return;
        }
        Vec3 vector3d = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double yView = vector3d.y();
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        RandomSource rand = playerEntity.getRandom();
        for (BlockPos p : ClientInfo.scryingPositions) {
            ParticleColor color = new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255));
            BlockPos renderPos = new BlockPos((Vec3i)p);
            if (Math.abs(yView - (double)p.getY()) >= 30.0) {
                renderPos = new BlockPos(p.getX(), (int)((double)p.getY() > yView ? yView + 20.0 : yView - 20.0), p.getZ());
                color = new ParticleColor(rand.nextInt(30), rand.nextInt(255), rand.nextInt(50));
            }
            if (Math.abs(yView - (double)p.getY()) >= 60.0) {
                renderPos = new BlockPos(p.getX(), (int)((double)p.getY() > yView ? yView + 20.0 : yView - 20.0), p.getZ());
                color = new ParticleColor(rand.nextInt(50), rand.nextInt(50), rand.nextInt(255));
            }
            world.addAlwaysVisibleParticle(GlowParticleData.createData(color, true), false, (double)renderPos.getX() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), (double)renderPos.getY() + 0.2 + ParticleUtil.inRange(-0.1, 0.1), (double)renderPos.getZ() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), 0.0, (double)0.03f, 0.0);
        }
    }
}

