/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event.timed;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.block.TemporaryBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.block.tile.TemporaryTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BuildPortalEvent
implements ITimedEvent {
    Level level;
    BlockPos targetPos;
    Direction direction;
    List<BlockPos> framePos = new ArrayList<BlockPos>();
    List<BlockPos> portalPos = new ArrayList<BlockPos>();
    int ticks;
    List<BlockPos> placedBlocks = new ArrayList<BlockPos>();
    WarpScrollData warpScrollData;

    public BuildPortalEvent(Level level, BlockPos targetPos, Direction direction, WarpScrollData warpScrollData) {
        this.level = level;
        this.targetPos = targetPos;
        this.direction = direction;
        this.ticks = 1;
        this.warpScrollData = warpScrollData;
        BlockPos aboveTarget = targetPos.above();
        int width = 2;
        BlockPos leftBotTarget = aboveTarget.offset(width * direction.getStepX(), 0, width * direction.getStepZ());
        BlockPos rightBotTarget = aboveTarget.offset(width * -direction.getStepX(), 0, width * -direction.getStepZ());
        for (BlockPos pos1 : BlockPos.betweenClosed((BlockPos)leftBotTarget, (BlockPos)rightBotTarget)) {
            this.framePos.add(pos1.immutable());
        }
        for (BlockPos pos1 : BlockPos.betweenClosed((BlockPos)rightBotTarget.above(), (BlockPos)rightBotTarget.above(3))) {
            this.framePos.add(pos1.immutable());
        }
        for (BlockPos pos1 : BlockPos.betweenClosed((BlockPos)leftBotTarget.above(4), (BlockPos)rightBotTarget.above(4))) {
            this.framePos.add(pos1.immutable());
        }
        for (BlockPos pos1 : BlockPos.betweenClosed((BlockPos)leftBotTarget.above(), (BlockPos)leftBotTarget.above(3))) {
            this.framePos.add(pos1.immutable());
        }
        BlockPos leftPortalOffset = aboveTarget.offset(direction.getStepX(), 1, direction.getStepZ());
        BlockPos rightPortalOffset = aboveTarget.offset(-direction.getStepX(), 3, -direction.getStepZ());
        for (BlockPos pos1 : BlockPos.betweenClosed((BlockPos)leftPortalOffset, (BlockPos)rightPortalOffset)) {
            this.portalPos.add(pos1.immutable());
        }
        Collections.shuffle(this.portalPos);
    }

    @Override
    public void tick(boolean serverSide) {
        boolean placingPortal;
        ServerLevel serverLevel;
        boolean destroyPortal;
        block17: {
            BlockPos pos;
            block21: {
                TemporaryTile tile;
                block20: {
                    TemporaryTile tile2;
                    BlockState bs;
                    block19: {
                        block18: {
                            boolean placingFrame;
                            ++this.ticks;
                            if (this.ticks < 5) {
                                return;
                            }
                            if (!serverSide || this.level.getGameTime() % 3L != 0L) {
                                return;
                            }
                            destroyPortal = false;
                            boolean bl = placingFrame = !this.framePos.isEmpty();
                            if (!placingFrame) break block17;
                            pos = this.framePos.get(0);
                            this.framePos.remove(pos);
                            bs = this.level.getBlockState(pos);
                            if (bs.is(BlockTagProvider.DECORATIVE_AN)) break block18;
                            BlockEntity blockEntity = this.level.getBlockEntity(pos);
                            if (!(blockEntity instanceof TemporaryTile)) break block19;
                            tile2 = (TemporaryTile)blockEntity;
                            if (!tile2.mimicState.is(BlockTagProvider.DECORATIVE_AN)) break block19;
                        }
                        this.tick(true);
                        BlockEntity blockEntity = this.level.getBlockEntity(pos);
                        if (blockEntity instanceof TemporaryTile) {
                            tile = (TemporaryTile)blockEntity;
                            tile.mimicState = BlockRegistry.getBlock("sourcestone").defaultBlockState();
                            tile.tickDuration = 1200;
                            tile.gameTime = this.level.getGameTime();
                            tile.updateBlock();
                        }
                        return;
                    }
                    if (bs.canBeReplaced()) break block20;
                    tile = this.level.getBlockEntity(pos);
                    if (!(tile instanceof TemporaryTile)) break block21;
                    tile2 = tile;
                    if (!tile2.mimicState.is(BlockTagProvider.DECORATIVE_AN)) break block21;
                }
                this.level.setBlock(pos, ((TemporaryBlock)BlockRegistry.TEMPORARY_BLOCK.get()).defaultBlockState(), 3);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (blockEntity instanceof TemporaryTile) {
                    tile = (TemporaryTile)blockEntity;
                    tile.mimicState = BlockRegistry.getBlock("sourcestone").defaultBlockState();
                    tile.tickDuration = 1200;
                    tile.gameTime = this.level.getGameTime();
                    tile.updateBlock();
                }
                this.level.playSound(null, pos, BlockRegistry.getBlock("sourcestone").defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtil.spawnTouchPacket(this.level, pos, ParticleColor.makeRandomColor(255, 255, 255, this.level.random));
                this.placedBlocks.add(pos);
                return;
            }
            destroyPortal = true;
            serverLevel = (ServerLevel)this.level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        boolean bl = placingPortal = !this.portalPos.isEmpty() && this.framePos.isEmpty() && !destroyPortal;
        if (placingPortal) {
            for (BlockPos pos : this.portalPos) {
                if (this.level.getBlockState(pos).canBeReplaced()) {
                    this.level.setBlock(pos, (BlockState)BlockRegistry.PORTAL_BLOCK.defaultBlockState().setValue(PortalBlock.AXIS, (Comparable)this.direction.getAxis()), 2);
                    this.level.playSound(null, pos, ((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.placedBlocks.add(pos);
                    continue;
                }
                destroyPortal = true;
                serverLevel = (ServerLevel)this.level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                break;
            }
            this.portalPos.clear();
        }
        if (destroyPortal) {
            for (BlockPos pos : this.placedBlocks) {
                this.level.destroyBlock(pos, false);
            }
            this.level.playSound(null, this.targetPos, (SoundEvent)SoundRegistry.GAIA_SPELL_SOUND.getSoundEvent().value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.portalPos.clear();
            this.framePos.clear();
            return;
        }
        if (this.portalPos.isEmpty()) {
            this.level.playSound(null, this.targetPos.above(2), (SoundEvent)SoundRegistry.TEMPESTRY_SPELL_SOUND.getSoundEvent().value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (BlockPos pos : this.placedBlocks) {
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof PortalTile)) continue;
                PortalTile portalTile = (PortalTile)blockEntity;
                portalTile.setFromScroll(this.warpScrollData);
            }
        }
    }

    @Override
    public boolean isExpired() {
        return this.portalPos.isEmpty() && this.framePos.isEmpty();
    }
}

