/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class SpellParchment
extends ModItem
implements ICasterTool {
    public SpellParchment(Item.Properties properties) {
        super(properties);
    }

    public SpellParchment() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster()));
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        return caster.getSpellName().isEmpty() ? super.getName(pStack) : Component.literal((String)caster.getSpellName());
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        stack.addToTooltip(DataComponentRegistry.SPELL_CASTER, context, tooltip2::add, flagIn);
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (caster != null && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }
}

