/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.common.perk.StarbunclePerk;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public record PerkMap(Map<IPerk, CompoundTag> map) {
    public static Codec<PerkMap> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).xmap(stringMap -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        stringMap.forEach((key, value) -> {
            if (key != null) {
                ResourceLocation loc = ResourceLocation.tryParse((String)key);
                if (loc == null) {
                    return;
                }
                IPerk perk = PerkRegistry.getPerkMap().getOrDefault(loc, StarbunclePerk.INSTANCE);
                builder.put((Object)perk, value);
            }
        });
        return new PerkMap((Map<IPerk, CompoundTag>)builder.build());
    }, obj -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        obj.map.forEach((key, value) -> builder.put((Object)key.getRegistryName().toString(), value));
        return builder.build();
    });

    public CompoundTag getOrDefault(IPerk slot, CompoundTag tag) {
        return this.map.getOrDefault(slot, tag);
    }

    public CompoundTag get(IPerk slot) {
        return this.map.get(slot);
    }

    public PerkMap put(IPerk slot, CompoundTag tag) {
        return new PerkMap(Util.copyAndPut(this.map, (Object)slot, (Object)tag));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkMap that = (PerkMap)o;
        return Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.map);
    }
}

