/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectInteract
extends AbstractEffect {
    public static EffectInteract INSTANCE = new EffectInteract();

    private EffectInteract() {
        super(GlyphLib.EffectInteractID, "Interact");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity e = rayTraceResult.getEntity();
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        boolean wasShiftDown = player.isShiftKeyDown();
        Pose previousPose = player.getPose();
        boolean shouldShift = spellStats.hasBuff(AugmentDampen.INSTANCE);
        if (!this.isRealPlayer((Entity)shooter)) {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            if (shouldShift) {
                player.setShiftKeyDown(true);
                player.setPose(Pose.CROUCHING);
            }
            this.useOnEntity(player, spellStats, e);
            for (ItemStack i : player.inventory.items) {
                manager.insertOrDrop(i, world, e.blockPosition());
            }
        } else {
            if (shouldShift) {
                wasShiftDown = player.isShiftKeyDown();
                previousPose = player.getPose();
                player.setShiftKeyDown(true);
                player.setPose(Pose.CROUCHING);
            }
            this.useOnEntity(player, spellStats, e);
        }
        if (shouldShift) {
            player.setShiftKeyDown(wasShiftDown);
            player.setPose(previousPose);
        }
    }

    public InteractionHand getHand(Player player) {
        return player instanceof ANFakePlayer ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public boolean handleBucket(ItemStack item, BucketItem bucket, Player player, BlockState state, Level world, BlockPos pos, BlockHitResult rayTraceResult, InteractionHand hand) {
        if (bucket.content == Fluids.EMPTY) {
            BlockPos target;
            boolean isBucketPickup = state.getBlock() instanceof BucketPickup && world.getFluidState(pos) != Fluids.EMPTY.defaultFluidState();
            BlockPos blockPos = target = isBucketPickup ? pos : pos.relative(rayTraceResult.getDirection());
            if (world.getFluidState(target) == Fluids.EMPTY.defaultFluidState()) {
                return false;
            }
            BlockState targetState = world.getBlockState(target);
            Block block = targetState.getBlock();
            if (!(block instanceof BucketPickup)) {
                return false;
            }
            BucketPickup bp = (BucketPickup)block;
            ItemStack pickup = bp.pickupBlock(player, (LevelAccessor)world, target, targetState);
            if (!pickup.isEmpty() && !player.hasInfiniteMaterials()) {
                bp.getPickupSound(targetState).ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
                world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, target);
                ItemStack result = ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)pickup);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.FILLED_BUCKET.trigger(serverPlayer, item);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)bucket));
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, result);
                } else if (!player.addItem(result)) {
                    player.level.addFreshEntity((Entity)new ItemEntity(player.level, player.getX(), player.getY(), player.getZ(), result));
                }
            }
            return !pickup.isEmpty();
        }
        boolean placed = bucket.emptyContents(player, world, pos, rayTraceResult, item);
        if (placed) {
            if (!player.hasInfiniteMaterials()) {
                ItemStack result = ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, result);
                } else if (!player.addItem(result)) {
                    player.level.addFreshEntity((Entity)new ItemEntity(player.level, player.getX(), player.getY(), player.getZ(), result));
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, item);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)bucket));
        }
        return placed;
    }

    public void useOnEntity(Player player, SpellStats spellStats, Entity target) {
        if (spellStats.isSensitive()) {
            ItemStack item = player.getItemInHand(this.getHand(player));
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                InteractionResult res = item.interactLivingEntity(player, livingEntity, this.getHand(player));
                if (res != InteractionResult.SUCCESS) {
                    target.interact(player, this.getHand(player));
                }
            } else {
                target.interact(player, this.getHand(player));
            }
        } else {
            player.interactOn(target, InteractionHand.MAIN_HAND);
        }
    }

    public void useOnBlock(Player player, SpellStats spellStats, BlockPos blockpos, BlockState blockstate, Level pLevel, BlockHitResult pHitResult) {
        InteractionResult interactionresult;
        ServerPlayer pPlayer = (ServerPlayer)player;
        InteractionHand pHand = spellStats.isSensitive() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (spellStats.hasBuff(AugmentAmplify.INSTANCE)) {
            blockstate.attack(pLevel, blockpos, (Player)pPlayer);
            return;
        }
        ItemInteractionResult iteminteractionresult = blockstate.useItemOn(pPlayer.getItemInHand(pHand), pLevel, (Player)pPlayer, pHand, pHitResult);
        Item item = itemstack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            this.handleBucket(itemstack, bucket, player, blockstate, pLevel, blockpos, pHitResult, this.getHand(player));
            return;
        }
        if (iteminteractionresult.consumesAction()) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(pPlayer, blockpos, itemstack);
        }
        if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && pHand == InteractionHand.MAIN_HAND && (interactionresult = blockstate.useWithoutItem(pLevel, (Player)pPlayer, pHitResult)).consumesAction()) {
            CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(pPlayer, blockpos);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos blockPos = rayTraceResult.getBlockPos();
        BlockState blockState = world.getBlockState(blockPos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, blockPos)) {
            return;
        }
        if (blockState.is(BlockTagProvider.INTERACT_BLACKLIST)) {
            return;
        }
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        boolean wasShiftDown = player.isShiftKeyDown();
        Pose previousPose = player.getPose();
        boolean shouldShift = spellStats.hasBuff(AugmentDampen.INSTANCE);
        if (this.isRealPlayer((Entity)shooter)) {
            if (shouldShift) {
                player.setShiftKeyDown(true);
                player.setPose(Pose.CROUCHING);
            }
            this.useOnBlock(player, spellStats, blockPos, blockState, world, rayTraceResult);
        } else {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            if (shouldShift) {
                wasShiftDown = player.isShiftKeyDown();
                previousPose = player.getPose();
                player.setShiftKeyDown(true);
                player.setPose(Pose.CROUCHING);
            }
            this.useOnBlock(player, spellStats, blockPos, blockState, world, rayTraceResult);
            for (ItemStack i : player.inventory.items) {
                manager.insertOrDrop(i, world, rayTraceResult.getBlockPos());
            }
            for (ItemStack i : player.inventory.offhand) {
                manager.insertOrDrop(i, world, rayTraceResult.getBlockPos());
            }
        }
        if (shouldShift) {
            player.setShiftKeyDown(wasShiftDown);
            player.setPose(previousPose);
        }
    }

    public FakePlayer setupFakeInventory(SpellContext context, Level level) {
        InventoryManager manager = context.getCaster().getInvManager();
        ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)level);
        player.inventory.clearContent();
        player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        player.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        ExtractedStack stack = manager.extractItem(i -> !i.isEmpty(), 1);
        if (!stack.isEmpty()) {
            player.setItemSlot(EquipmentSlot.MAINHAND, stack.getStack().copy());
        }
        return player;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentSensitive.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put(AugmentSensitive.INSTANCE, "Will interact with your off-hand item.");
        map.put(AugmentAmplify.INSTANCE, "Uses left-click instead of right-click.");
        map.put(AugmentDampen.INSTANCE, "Will use shift clicks.");
    }

    @Override
    public String getBookDescription() {
        return "Interacts with blocks or entities as it were a player. Useful for reaching levers, chests, or animals. Sensitive will use your off-hand item on the block or entity, Amplify will use left-click instead of right-click on blocks.";
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

