/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.tree;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.setup.ModSetup;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class MagicTrunkPlacer
extends TrunkPlacer {
    boolean isWorldGen;
    ResourceLocation podID;
    public static final MapCodec<MagicTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(placer -> placer.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.heightRandA), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.heightRandB), (App)Codec.BOOL.fieldOf("isWorldGen").forGetter(placer -> placer.isWorldGen), (App)Codec.STRING.fieldOf("podID").forGetter(placer -> placer.podID.toString())).apply((Applicative)builder, MagicTrunkPlacer::new));

    public MagicTrunkPlacer(int baseHeight, int height_rand_a, int height_rand_b) {
        super(baseHeight, height_rand_a, height_rand_b);
    }

    public MagicTrunkPlacer(int baseHeight, int height_rand_a, int height_rand_b, boolean isWorldGen, String podName) {
        this(baseHeight, height_rand_a, height_rand_b);
        this.isWorldGen = isWorldGen;
        this.podID = ResourceLocation.tryParse((String)podName);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModSetup.MAGIC_TRUNK_PLACER.get();
    }

    protected static void setDirtAt(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, boolean isTreeOrigin) {
        if (isTreeOrigin || pLevel.isStateAtPosition(pPos, state -> state.is(BlockTags.DIRT) || state.is(Blocks.FARMLAND))) {
            TrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos, (TreeConfiguration)pConfig);
        }
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int foliageHeight, BlockPos pos, TreeConfiguration baseTreeFeatureConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = pos.below();
        MagicTrunkPlacer.setDirtAt(world, consumer, rand, blockpos, baseTreeFeatureConfig, true);
        MagicTrunkPlacer.setDirtAt(world, consumer, rand, blockpos.east(), baseTreeFeatureConfig, false);
        MagicTrunkPlacer.setDirtAt(world, consumer, rand, blockpos.south(), baseTreeFeatureConfig, false);
        MagicTrunkPlacer.setDirtAt(world, consumer, rand, blockpos.south().east(), baseTreeFeatureConfig, false);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int yOffset = y + foliageHeight - 1;
        int numBranches = 0;
        int lastBranch = 0;
        double branchChance = 0.5;
        boolean northB = (double)rand.nextFloat() >= branchChance;
        boolean southB = (double)rand.nextFloat() >= branchChance;
        boolean eastB = (double)rand.nextFloat() >= branchChance;
        boolean westB = (double)rand.nextFloat() >= branchChance;
        for (int i = 0; i < foliageHeight; ++i) {
            int j2 = y + i;
            BlockPos blockpos1 = new BlockPos(x, j2, z);
            if (TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos1)) {
                this.placeLog(world, consumer, rand, blockpos1, baseTreeFeatureConfig);
                this.placeLog(world, consumer, rand, blockpos1.east(), baseTreeFeatureConfig);
                this.placeLog(world, consumer, rand, blockpos1.south(), baseTreeFeatureConfig);
                this.placeLog(world, consumer, rand, blockpos1.east().south(), baseTreeFeatureConfig);
            }
            if (i == 0) {
                BlockPos abovePos = pos.above(i);
                this.addRoots(world, rand, abovePos.west(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.NORTH, Direction.WEST});
                this.addRoots(world, rand, abovePos.south(2), consumer, baseTreeFeatureConfig, new Direction[]{Direction.SOUTH, Direction.WEST});
                this.addRoots(world, rand, abovePos.south().west(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.WEST});
                this.addRoots(world, rand, abovePos.south(2).east(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.EAST, Direction.SOUTH});
                this.addRoots(world, rand, abovePos.east(2), consumer, baseTreeFeatureConfig, new Direction[]{Direction.EAST, Direction.NORTH});
                this.addRoots(world, rand, abovePos.east(2).south(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.EAST});
                this.addRoots(world, rand, abovePos.east().north(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.NORTH});
                this.addRoots(world, rand, abovePos.north(), consumer, baseTreeFeatureConfig, new Direction[]{Direction.NORTH, Direction.EAST});
            }
            if (i > 1 && i > lastBranch) {
                if (northB) {
                    this.addBranch(world, pos, i, Direction.NORTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    northB = false;
                } else if (southB) {
                    this.addBranch(world, pos.relative(Direction.SOUTH), i, Direction.SOUTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    southB = false;
                } else if (eastB) {
                    this.addBranch(world, pos.relative(Direction.EAST).south(), i, Direction.EAST, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    eastB = false;
                } else if (westB) {
                    this.addBranch(world, pos, i, Direction.WEST, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    westB = false;
                } else if (numBranches == 0) {
                    this.addBranch(world, pos, i, Direction.NORTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    this.addBranch(world, pos, i, Direction.SOUTH, rand, baseTreeFeatureConfig, consumer);
                    ++numBranches;
                }
            }
            if (i == foliageHeight - 2) {
                float leafChance = 0.1f;
                this.addLineLeaves(world, pos.north(4).above(i), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.north(4).above(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.north(3).above(i - 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.north(3).above(i), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.north(3).above(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.north(2).above(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.north(1).above(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.north(2).above(i + 2), Direction.NORTH, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(5).above(i), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(5).above(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(4).above(i - 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(4).above(i), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(4).above(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(3).above(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(2).above(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(3).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(2).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(1).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(0).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(-1).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(-2).above(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.west(4).south().above(i), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.west(4).south().above(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.west(3).south().above(i - 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.west(3).south().above(i), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.west(3).south().above(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.west(2).south().above(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.west(1).south().above(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.west(2).south().above(i + 2), Direction.WEST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.south(4).east().above(i), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.south(4).east().above(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.south(5).east().above(i), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.south(5).east().above(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.south(3).east().above(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.south(2).east().above(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.south(3).east().above(i + 2), Direction.SOUTH, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(2).above(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(1).above(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(0).above(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(-1).above(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
                this.addLineLeaves(world, pos.east(2).above(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(1).above(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(0).above(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
                this.addLineLeaves(world, pos.east(-1).above(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
            }
            if (!this.isWorldGen || i < 2 || i >= foliageHeight - 2) continue;
            this.addPod(world, blockpos1, rand, consumer, new Direction[]{Direction.NORTH, Direction.WEST});
            this.addPod(world, blockpos1.east(), rand, consumer, new Direction[]{Direction.NORTH, Direction.EAST});
            this.addPod(world, blockpos1.south(), rand, consumer, new Direction[]{Direction.SOUTH, Direction.WEST});
            this.addPod(world, blockpos1.south().east(), rand, consumer, new Direction[]{Direction.SOUTH, Direction.EAST});
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, yOffset, z), 0, true));
        return list;
    }

    public void addPod(LevelSimulatedReader world, BlockPos pos, RandomSource random, BiConsumer<BlockPos, BlockState> consumer, Direction[] validDirs) {
        if (random.nextDouble() <= 0.07) {
            Direction d = validDirs[random.nextInt(validDirs.length)];
            int age = random.nextIntBetweenInclusive(0, 2);
            if (world.isStateAtPosition(pos.relative(d), BlockBehaviour.BlockStateBase::isAir)) {
                this.setBlock(world, pos.relative(d).immutable(), (BlockState)((BlockState)((BlockState)this.getPodState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)d.getOpposite())).setValue(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(6 + age))).setValue((Property)ArchfruitPod.AGE, (Comparable)Integer.valueOf(age)), consumer);
            }
        }
    }

    public BlockState getPodState() {
        return ((Block)BuiltInRegistries.BLOCK.get(this.podID)).defaultBlockState();
    }

    public void addBranch(LevelSimulatedReader world, BlockPos pos, int height, Direction d, RandomSource random, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        pos = pos.above(height);
        this.addLog(world, pos.relative(d), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.relative(d).above(1), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.relative(d).above(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.relative(d, 2).above(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.relative(d, 3).above(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.relative(d, 3).above(1), random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.relative(d).above(1), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.relative(d).above(2), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.relative(d).above(3), d, 3, random, baseTreeFeatureConfig, consumer);
        for (int j = 1; j < 4; ++j) {
            this.addLineLeaves(world, pos.relative(d, j).above(3), d, 3, random, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.relative(d, j).above(2), d, 3, random, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.relative(d, j).above(4), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        }
        for (int i = 0; i < 2; ++i) {
            this.addHollowLine(world, pos.relative(d, 2 + i).above(1), d, 2, random, baseTreeFeatureConfig, consumer);
            this.addHollowLine(world, pos.relative(d, 2 + i).above(2), d, 2, random, baseTreeFeatureConfig, consumer);
            this.addHollowLine(world, pos.relative(d, 2 + i).above(1), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
            this.addHollowLine(world, pos.relative(d, 2 + i).above(2), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        }
        this.addLineLeaves(world, pos.relative(d, 4).above(1), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.relative(d, 4).above(2), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.relative(d, 5).above(1), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        this.addLineLeaves(world, pos.relative(d, 5).above(2), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
    }

    public boolean addLog(LevelSimulatedReader world, BlockPos pos, RandomSource random, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        return this.addBlock(world, pos, baseTreeFeatureConfig.trunkProvider.getState(random, pos), consumer);
    }

    public boolean addBlock(LevelSimulatedReader world, BlockPos pos, BlockState state, BiConsumer<BlockPos, BlockState> consumer) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.setBlock(world, pos, state, consumer);
            return true;
        }
        return false;
    }

    public void addHollowLine(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        this.addHollowLine(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
    }

    public void addHollowLine(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.getClockWise();
        Direction right = left.getOpposite();
        if (rand.nextFloat() <= chance && TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.relative(left, length))) {
            this.setBlock(world, pos.relative(left, length), baseTreeFeatureConfig.foliageProvider.getState(rand, pos.relative(left, length)), consumer);
        }
        if (rand.nextFloat() <= chance && TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.relative(right, length))) {
            this.setBlock(world, pos.relative(right, length), baseTreeFeatureConfig.foliageProvider.getState(rand, pos.relative(right, length)), consumer);
        }
    }

    public void addLineLeaves(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
        } else {
            this.addLineLeavesOdd(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
        }
    }

    public void addLineLeaves(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, d, length, rand, baseTreeFeatureConfig, chance, consumer);
        } else {
            this.addLineLeavesOdd(world, pos, d, length, rand, baseTreeFeatureConfig, chance, consumer);
        }
    }

    public void addLineLeavesEven(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.getClockWise();
        Direction right = left.getOpposite();
        for (int i = 0; i < length; ++i) {
            if (!(rand.nextFloat() <= chance) || !TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.relative(left, i - length / 3))) continue;
            this.setBlock(world, pos.relative(left, i - length / 3), baseTreeFeatureConfig.foliageProvider.getState(rand, pos.relative(left, i - length / 3)), consumer);
        }
    }

    public void addLineLeavesOdd(LevelSimulatedReader world, BlockPos pos, Direction d, int length, RandomSource rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.getClockWise();
        Direction right = left.getOpposite();
        length += 2;
        for (int i = 0; i < (length - 1) / 2; ++i) {
            if (rand.nextFloat() <= chance && TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.relative(left, i))) {
                this.setBlock(world, pos.relative(left, i), baseTreeFeatureConfig.foliageProvider.getState(rand, pos.relative(left, i)), consumer);
            }
            if (!(rand.nextFloat() <= chance) || !TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.relative(right, i))) continue;
            this.setBlock(world, pos.relative(right, i), baseTreeFeatureConfig.foliageProvider.getState(rand, pos.relative(right, i)), consumer);
        }
    }

    public boolean addRoots(LevelSimulatedReader world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, TreeConfiguration baseTreeFeatureConfig, Direction[] extendedDirs) {
        BlockState state = baseTreeFeatureConfig.trunkProvider.getState(rand, pos);
        if (rand.nextDouble() < 0.75 && TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.setBlock(world, pos.immutable(), state, consumer);
            if (this.isWorldGen) {
                for (int i = 0; i < 2 && TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos.below()); ++i) {
                    pos = pos.below();
                    this.setBlock(world, pos.immutable(), state, consumer);
                }
                for (Direction d : extendedDirs) {
                    this.placeRotatedRoot(world, rand, pos.below().relative(d), consumer, baseTreeFeatureConfig, d);
                }
                return true;
            }
        }
        return false;
    }

    public boolean placeRotatedRoot(LevelSimulatedReader world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, TreeConfiguration baseTreeFeatureConfig, Direction direction) {
        BlockState state = baseTreeFeatureConfig.trunkProvider.getState(rand, pos);
        if (state.hasProperty((Property)RotatedPillarBlock.AXIS)) {
            state = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
        }
        if (rand.nextDouble() < 0.6 && this.validForExtendedRoot(world, pos)) {
            this.setBlock(world, pos.immutable(), state, consumer);
            int count = 0;
            while (rand.nextDouble() < 0.8 - (double)count * 0.3) {
                ++count;
                if (rand.nextDouble() < 0.7) {
                    direction = rand.nextDouble() < 0.5 ? direction.getClockWise() : direction.getCounterClockWise();
                    state = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                }
                if (TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)(pos = pos.relative(direction)).below())) {
                    pos = pos.below();
                }
                if (!this.validForExtendedRoot(world, pos)) break;
                this.setBlock(world, pos.immutable(), state, consumer);
            }
            return true;
        }
        return false;
    }

    public boolean validForExtendedRoot(LevelSimulatedReader world, BlockPos pos) {
        return TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos) || world.isStateAtPosition(pos, b -> b.getBlock() == Blocks.DIRT || b.getBlock() == Blocks.GRASS_BLOCK);
    }

    public void setBlock(LevelSimulatedReader world, BlockPos pos, BlockState state, BiConsumer<BlockPos, BlockState> consumer) {
        consumer.accept(pos, state);
    }
}

