/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;

public class BannerRegistry {
    public static final ResourceKey<BannerPattern> FIRE = BannerRegistry.create("fire");
    public static final ResourceKey<BannerPattern> WATER = BannerRegistry.create("water");
    public static final ResourceKey<BannerPattern> EARTH = BannerRegistry.create("earth");
    public static final ResourceKey<BannerPattern> AIR = BannerRegistry.create("air");
    public static final ResourceKey<BannerPattern> MANIPULATION = BannerRegistry.create("manipulation");
    public static final ResourceKey<BannerPattern> CONJURATION = BannerRegistry.create("conjuration");
    public static final ResourceKey<BannerPattern> ABJURATION = BannerRegistry.create("abjuration");
    public static final ResourceKey<BannerPattern> SPIRALS = BannerRegistry.create("spirals");

    private static ResourceKey<BannerPattern> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)name));
    }

    public static void bootstrapPatterns(BootstrapContext<BannerPattern> bannerPatternBootstrapContext) {
        BannerRegistry.register(bannerPatternBootstrapContext, FIRE);
        BannerRegistry.register(bannerPatternBootstrapContext, WATER);
        BannerRegistry.register(bannerPatternBootstrapContext, EARTH);
        BannerRegistry.register(bannerPatternBootstrapContext, AIR);
        BannerRegistry.register(bannerPatternBootstrapContext, MANIPULATION);
        BannerRegistry.register(bannerPatternBootstrapContext, CONJURATION);
        BannerRegistry.register(bannerPatternBootstrapContext, ABJURATION);
        BannerRegistry.register(bannerPatternBootstrapContext, SPIRALS);
    }

    public static void register(BootstrapContext<BannerPattern> context, ResourceKey<BannerPattern> resourceKey) {
        context.register(resourceKey, (Object)new BannerPattern(resourceKey.location(), "block.ars_nouveau.banner." + resourceKey.location().toShortLanguageKey()));
    }
}

