/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.xml.builders;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.queryparser.xml.DOMUtils;
import org.apache.lucene.ars_nouveau.queryparser.xml.ParserException;
import org.apache.lucene.ars_nouveau.queryparser.xml.QueryBuilder;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.BooleanQuery;
import org.apache.lucene.ars_nouveau.search.BoostQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.TermQuery;
import org.w3c.dom.Element;

public class TermsQueryBuilder
implements QueryBuilder {
    private final Analyzer analyzer;

    public TermsQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String text = DOMUtils.getNonBlankTextOrFail(e);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setMinimumNumberShouldMatch(DOMUtils.getAttribute(e, "minimumNumberShouldMatch", 0));
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, text);){
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            Term term = null;
            ts.reset();
            while (ts.incrementToken()) {
                term = new Term(fieldName, termAtt.getBytesRef());
                bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
            }
            ts.end();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error constructing terms from index:" + String.valueOf(ioe));
        }
        BooleanQuery q = bq.build();
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new BoostQuery(q, boost);
    }
}

